/* This file was generated by SableCC (http://www.sablecc.org/). */

package soot.jimple.parser.lexer;

import java.io.*;
import soot.jimple.parser.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            @SuppressWarnings("hiding") Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            @SuppressWarnings("hiding") Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            @SuppressWarnings("hiding") Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            @SuppressWarnings("hiding") Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            @SuppressWarnings("hiding") Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            @SuppressWarnings("hiding") Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            @SuppressWarnings("hiding") Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            @SuppressWarnings("hiding") Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            @SuppressWarnings("hiding") Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            @SuppressWarnings("hiding") Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            @SuppressWarnings("hiding") Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            @SuppressWarnings("hiding") Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            @SuppressWarnings("hiding") Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            @SuppressWarnings("hiding") Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            @SuppressWarnings("hiding") Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            @SuppressWarnings("hiding") Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            @SuppressWarnings("hiding") Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            @SuppressWarnings("hiding") Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            @SuppressWarnings("hiding") Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            @SuppressWarnings("hiding") Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            @SuppressWarnings("hiding") Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            @SuppressWarnings("hiding") Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            @SuppressWarnings("hiding") Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            @SuppressWarnings("hiding") Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            @SuppressWarnings("hiding") Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            @SuppressWarnings("hiding") Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            @SuppressWarnings("hiding") Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            @SuppressWarnings("hiding") Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            @SuppressWarnings("hiding") Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            @SuppressWarnings("hiding") Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            @SuppressWarnings("hiding") Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            @SuppressWarnings("hiding") Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            @SuppressWarnings("hiding") Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            @SuppressWarnings("hiding") Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            @SuppressWarnings("hiding") Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            @SuppressWarnings("hiding") Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            @SuppressWarnings("hiding") Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            @SuppressWarnings("hiding") Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            @SuppressWarnings("hiding") Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            @SuppressWarnings("hiding") Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            @SuppressWarnings("hiding") Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            @SuppressWarnings("hiding") Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                            @SuppressWarnings("hiding") Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                            @SuppressWarnings("hiding") Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                            @SuppressWarnings("hiding") Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                            @SuppressWarnings("hiding") Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                            @SuppressWarnings("hiding") Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                            @SuppressWarnings("hiding") Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                            @SuppressWarnings("hiding") Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                            @SuppressWarnings("hiding") Token token = new69(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                            @SuppressWarnings("hiding") Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                            @SuppressWarnings("hiding") Token token = new71(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                            @SuppressWarnings("hiding") Token token = new72(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                            @SuppressWarnings("hiding") Token token = new73(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                            @SuppressWarnings("hiding") Token token = new74(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                            @SuppressWarnings("hiding") Token token = new75(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                            @SuppressWarnings("hiding") Token token = new76(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                            @SuppressWarnings("hiding") Token token = new77(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                            @SuppressWarnings("hiding") Token token = new78(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                            @SuppressWarnings("hiding") Token token = new79(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                            @SuppressWarnings("hiding") Token token = new80(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 81:
                        {
                            @SuppressWarnings("hiding") Token token = new81(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 82:
                        {
                            @SuppressWarnings("hiding") Token token = new82(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 83:
                        {
                            @SuppressWarnings("hiding") Token token = new83(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 84:
                        {
                            @SuppressWarnings("hiding") Token token = new84(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 85:
                        {
                            @SuppressWarnings("hiding") Token token = new85(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 86:
                        {
                            @SuppressWarnings("hiding") Token token = new86(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 87:
                        {
                            @SuppressWarnings("hiding") Token token = new87(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 88:
                        {
                            @SuppressWarnings("hiding") Token token = new88(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 89:
                        {
                            @SuppressWarnings("hiding") Token token = new89(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 90:
                        {
                            @SuppressWarnings("hiding") Token token = new90(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 91:
                        {
                            @SuppressWarnings("hiding") Token token = new91(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 92:
                        {
                            @SuppressWarnings("hiding") Token token = new92(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 93:
                        {
                            @SuppressWarnings("hiding") Token token = new93(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 94:
                        {
                            @SuppressWarnings("hiding") Token token = new94(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 95:
                        {
                            @SuppressWarnings("hiding") Token token = new95(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 96:
                        {
                            @SuppressWarnings("hiding") Token token = new96(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 97:
                        {
                            @SuppressWarnings("hiding") Token token = new97(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 98:
                        {
                            @SuppressWarnings("hiding") Token token = new98(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 99:
                        {
                            @SuppressWarnings("hiding") Token token = new99(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 100:
                        {
                            @SuppressWarnings("hiding") Token token = new100(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIgnored(text, line, pos); }
    Token new1(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAbstract(line, pos); }
    Token new2(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFinal(line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNative(line, pos); }
    Token new4(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPublic(line, pos); }
    Token new5(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TProtected(line, pos); }
    Token new6(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPrivate(line, pos); }
    Token new7(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStatic(line, pos); }
    Token new8(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSynchronized(line, pos); }
    Token new9(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTransient(line, pos); }
    Token new10(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVolatile(line, pos); }
    Token new11(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStrictfp(line, pos); }
    Token new12(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEnum(line, pos); }
    Token new13(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAnnotation(line, pos); }
    Token new14(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TClass(line, pos); }
    Token new15(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInterface(line, pos); }
    Token new16(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVoid(line, pos); }
    Token new17(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBoolean(line, pos); }
    Token new18(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TByte(line, pos); }
    Token new19(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShort(line, pos); }
    Token new20(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TChar(line, pos); }
    Token new21(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInt(line, pos); }
    Token new22(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLong(line, pos); }
    Token new23(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFloat(line, pos); }
    Token new24(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDouble(line, pos); }
    Token new25(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNullType(line, pos); }
    Token new26(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUnknown(line, pos); }
    Token new27(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExtends(line, pos); }
    Token new28(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TImplements(line, pos); }
    Token new29(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBreakpoint(line, pos); }
    Token new30(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCase(line, pos); }
    Token new31(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCatch(line, pos); }
    Token new32(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmp(line, pos); }
    Token new33(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpg(line, pos); }
    Token new34(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpl(line, pos); }
    Token new35(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDefault(line, pos); }
    Token new36(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEntermonitor(line, pos); }
    Token new37(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExitmonitor(line, pos); }
    Token new38(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TGoto(line, pos); }
    Token new39(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIf(line, pos); }
    Token new40(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInstanceof(line, pos); }
    Token new41(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInterfaceinvoke(line, pos); }
    Token new42(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLengthof(line, pos); }
    Token new43(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLookupswitch(line, pos); }
    Token new44(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNeg(line, pos); }
    Token new45(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNew(line, pos); }
    Token new46(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNewarray(line, pos); }
    Token new47(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNewmultiarray(line, pos); }
    Token new48(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNop(line, pos); }
    Token new49(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRet(line, pos); }
    Token new50(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TReturn(line, pos); }
    Token new51(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSpecialinvoke(line, pos); }
    Token new52(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStaticinvoke(line, pos); }
    Token new53(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDynamicinvoke(line, pos); }
    Token new54(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTableswitch(line, pos); }
    Token new55(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TThrow(line, pos); }
    Token new56(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TThrows(line, pos); }
    Token new57(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVirtualinvoke(line, pos); }
    Token new58(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNull(line, pos); }
    Token new59(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFrom(line, pos); }
    Token new60(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTo(line, pos); }
    Token new61(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWith(line, pos); }
    Token new62(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCls(line, pos); }
    Token new63(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComma(line, pos); }
    Token new64(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBrace(line, pos); }
    Token new65(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBrace(line, pos); }
    Token new66(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSemicolon(line, pos); }
    Token new67(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBracket(line, pos); }
    Token new68(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBracket(line, pos); }
    Token new69(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLParen(line, pos); }
    Token new70(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRParen(line, pos); }
    Token new71(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TColon(line, pos); }
    Token new72(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDot(line, pos); }
    Token new73(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TQuote(line, pos); }
    Token new74(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TColonEquals(line, pos); }
    Token new75(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEquals(line, pos); }
    Token new76(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAnd(line, pos); }
    Token new77(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOr(line, pos); }
    Token new78(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TXor(line, pos); }
    Token new79(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMod(line, pos); }
    Token new80(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpeq(line, pos); }
    Token new81(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpne(line, pos); }
    Token new82(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpgt(line, pos); }
    Token new83(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpge(line, pos); }
    Token new84(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmplt(line, pos); }
    Token new85(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmple(line, pos); }
    Token new86(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShl(line, pos); }
    Token new87(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShr(line, pos); }
    Token new88(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUshr(line, pos); }
    Token new89(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPlus(line, pos); }
    Token new90(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMinus(line, pos); }
    Token new91(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMult(line, pos); }
    Token new92(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDiv(line, pos); }
    Token new93(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFullIdentifier(text, line, pos); }
    Token new94(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TQuotedName(text, line, pos); }
    Token new95(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIdentifier(text, line, pos); }
    Token new96(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAtIdentifier(text, line, pos); }
    Token new97(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBoolConstant(text, line, pos); }
    Token new98(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIntegerConstant(text, line, pos); }
    Token new99(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFloatConstant(text, line, pos); }
    Token new100(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStringConstant(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {33, 33, 5}, {34, 34, 6}, {35, 35, 7}, {36, 36, 8}, {37, 37, 9}, {38, 38, 10}, {39, 39, 11}, {40, 40, 12}, {41, 41, 13}, {42, 42, 14}, {43, 43, 15}, {44, 44, 16}, {45, 45, 17}, {46, 46, 18}, {47, 47, 19}, {48, 48, 20}, {49, 57, 21}, {58, 58, 22}, {59, 59, 23}, {60, 60, 24}, {61, 61, 25}, {62, 62, 26}, {64, 64, 27}, {65, 90, 28}, {91, 91, 29}, {92, 92, 30}, {93, 93, 31}, {94, 94, 32}, {95, 95, 33}, {97, 97, 34}, {98, 98, 35}, {99, 99, 36}, {100, 100, 37}, {101, 101, 38}, {102, 102, 39}, {103, 103, 40}, {104, 104, 41}, {105, 105, 42}, {106, 107, 41}, {108, 108, 43}, {109, 109, 41}, {110, 110, 44}, {111, 111, 41}, {112, 112, 45}, {113, 113, 41}, {114, 114, 46}, {115, 115, 47}, {116, 116, 48}, {117, 117, 49}, {118, 118, 50}, {119, 119, 51}, {120, 122, 41}, {123, 123, 52}, {124, 124, 53}, {125, 125, 54}, },
            {{9, 32, -2}, {47, 47, 55}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{61, 61, 56}, },
            {{0, 33, 57}, {34, 34, 58}, {35, 91, 59}, {92, 92, 60}, {93, 127, 61}, },
            {{45, 45, 62}, {73, 73, 63}, {78, 78, 64}, },
            {{36, 36, 65}, {46, 46, 66}, {48, 57, 67}, {65, 90, 68}, {92, 92, 69}, {95, 95, 70}, {97, 122, 71}, },
            {},
            {},
            {{0, 9, 72}, {11, 12, 72}, {14, 38, 72}, {40, 65535, 72}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{42, 42, 73}, {47, 47, 74}, },
            {{46, 46, 75}, {48, 55, 76}, {56, 57, 21}, {76, 76, 77}, {88, 88, 78}, {120, 120, 79}, },
            {{46, 46, 75}, {48, 57, 21}, {76, 76, 77}, },
            {{61, 61, 80}, },
            {},
            {{60, 60, 81}, {61, 61, 82}, {99, 99, 83}, {105, 105, 84}, },
            {{61, 61, 85}, },
            {{61, 61, 86}, {62, 62, 87}, },
            {{99, 99, 88}, {112, 112, 89}, {116, 116, 90}, },
            {{36, 122, -10}, },
            {},
            {{32, 32, 91}, {34, 34, 92}, {35, 35, 93}, {39, 39, 94}, {46, 46, 95}, {92, 92, 96}, {98, 98, 97}, {102, 102, 98}, {110, 110, 99}, {114, 114, 100}, {116, 116, 101}, {117, 117, 102}, },
            {},
            {},
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 71}, {98, 98, 103}, {99, 109, 71}, {110, 110, 104}, {111, 122, 71}, },
            {{36, 95, -10}, {97, 110, 71}, {111, 111, 105}, {112, 113, 71}, {114, 114, 106}, {115, 120, 71}, {121, 121, 107}, {122, 122, 71}, },
            {{36, 95, -10}, {97, 97, 108}, {98, 103, 71}, {104, 104, 109}, {105, 107, 71}, {108, 108, 110}, {109, 109, 111}, {110, 122, 71}, },
            {{36, 95, -10}, {97, 100, 71}, {101, 101, 112}, {102, 110, 71}, {111, 111, 113}, {112, 120, 71}, {121, 121, 114}, {122, 122, 71}, },
            {{36, 95, -10}, {97, 109, 71}, {110, 110, 115}, {111, 119, 71}, {120, 120, 116}, {121, 122, 71}, },
            {{36, 95, -10}, {97, 97, 117}, {98, 104, 71}, {105, 105, 118}, {106, 107, 71}, {108, 108, 119}, {109, 113, 71}, {114, 114, 120}, {115, 122, 71}, },
            {{36, 110, -37}, {111, 111, 121}, {112, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 101, 71}, {102, 102, 122}, {103, 108, 71}, {109, 109, 123}, {110, 110, 124}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 125}, {102, 110, 71}, {111, 111, 126}, {112, 122, 71}, },
            {{36, 95, -10}, {97, 97, 127}, {98, 100, 71}, {101, 101, 128}, {102, 110, 71}, {111, 111, 129}, {112, 116, 71}, {117, 117, 130}, {118, 122, 71}, },
            {{36, 95, -10}, {97, 113, 71}, {114, 114, 131}, {115, 116, 71}, {117, 117, 132}, {118, 122, 71}, },
            {{36, 100, -39}, {101, 101, 133}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 103, 71}, {104, 104, 134}, {105, 111, 71}, {112, 112, 135}, {113, 115, 71}, {116, 116, 136}, {117, 120, 71}, {121, 121, 137}, {122, 122, 71}, },
            {{36, 95, -10}, {97, 97, 138}, {98, 103, 71}, {104, 104, 139}, {105, 110, 71}, {111, 111, 140}, {112, 113, 71}, {114, 114, 141}, {115, 122, 71}, },
            {{36, 109, -40}, {110, 110, 142}, {111, 122, 71}, },
            {{36, 95, -10}, {97, 104, 71}, {105, 105, 143}, {106, 110, 71}, {111, 111, 144}, {112, 122, 71}, },
            {{36, 104, -52}, {105, 105, 145}, {106, 122, 71}, },
            {},
            {},
            {},
            {{42, 47, -21}, },
            {},
            {{0, 127, -8}, },
            {},
            {{0, 127, -8}, },
            {{32, 32, 146}, {34, 34, 147}, {35, 35, 148}, {39, 39, 149}, {46, 46, 150}, {92, 92, 151}, {98, 98, 152}, {102, 102, 153}, {110, 110, 154}, {114, 114, 155}, {116, 116, 156}, {117, 117, 157}, },
            {{0, 127, -8}, },
            {{73, 73, 63}, },
            {{110, 110, 158}, },
            {{97, 97, 159}, },
            {{36, 122, -10}, },
            {{36, 36, 160}, {65, 90, 161}, {92, 92, 162}, {95, 95, 163}, {97, 122, 164}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{32, 32, 165}, {34, 34, 166}, {35, 35, 167}, {39, 39, 168}, {46, 46, 169}, {92, 92, 170}, {98, 98, 171}, {102, 102, 172}, {110, 110, 173}, {114, 114, 174}, {116, 116, 175}, {117, 117, 176}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 38, -13}, {39, 39, 177}, {40, 65535, 72}, },
            {{0, 41, 178}, {42, 42, 179}, {43, 65535, 178}, },
            {{0, 8, 180}, {9, 9, 181}, {10, 10, 2}, {11, 12, 180}, {13, 13, 3}, {14, 31, 180}, {32, 32, 182}, {33, 46, 180}, {47, 47, 183}, {48, 65535, 180}, },
            {{48, 57, 184}, },
            {{46, 76, -22}, },
            {},
            {{48, 57, 185}, {65, 70, 186}, {97, 102, 187}, },
            {{48, 102, -80}, },
            {},
            {},
            {},
            {{108, 108, 188}, },
            {{110, 110, 189}, },
            {},
            {},
            {{62, 62, 190}, },
            {{97, 97, 191}, },
            {{97, 97, 192}, },
            {{104, 104, 193}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 194}, {65, 70, 195}, {97, 102, 196}, },
            {{36, 95, -10}, {97, 114, 71}, {115, 115, 197}, {116, 122, 71}, },
            {{36, 109, -40}, {110, 110, 198}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 199}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 200}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 115, 71}, {116, 116, 201}, {117, 122, 71}, },
            {{36, 114, -105}, {115, 115, 202}, {116, 116, 203}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 97, 204}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 205}, {98, 114, 71}, {115, 115, 206}, {116, 122, 71}, },
            {{36, 95, -10}, {97, 111, 71}, {112, 112, 207}, {113, 122, 71}, },
            {{36, 101, -44}, {102, 102, 208}, {103, 122, 71}, },
            {{36, 95, -10}, {97, 116, 71}, {117, 117, 209}, {118, 122, 71}, },
            {{36, 109, -40}, {110, 110, 210}, {111, 122, 71}, },
            {{36, 115, -109}, {116, 116, 211}, {117, 117, 212}, {118, 122, 71}, },
            {{36, 104, -52}, {105, 105, 213}, {106, 115, 71}, {116, 116, 214}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 107, 71}, {108, 108, 215}, {109, 122, 71}, },
            {{36, 109, -40}, {110, 110, 216}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 217}, {112, 122, 71}, },
            {{36, 110, -37}, {111, 111, 218}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 219}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 111, -113}, {112, 112, 220}, {113, 122, 71}, },
            {{36, 114, -105}, {115, 115, 221}, {116, 116, 222}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 223}, {111, 122, 71}, },
            {{36, 109, -40}, {110, 110, 224}, {111, 111, 225}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 226}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 102, 71}, {103, 103, 227}, {104, 118, 71}, {119, 119, 228}, {120, 122, 71}, },
            {{36, 111, -113}, {112, 112, 229}, {113, 122, 71}, },
            {{36, 107, -119}, {108, 108, 230}, {109, 122, 71}, },
            {{36, 104, -52}, {105, 105, 231}, {106, 110, 71}, {111, 111, 232}, {112, 122, 71}, },
            {{36, 97, -36}, {98, 98, 233}, {99, 122, 71}, },
            {{36, 115, -109}, {116, 116, 234}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 235}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 236}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 97, 237}, {98, 113, 71}, {114, 114, 238}, {115, 122, 71}, },
            {{36, 109, -40}, {110, 110, 239}, {111, 122, 71}, },
            {{36, 97, -36}, {98, 98, 240}, {99, 122, 71}, },
            {{36, 113, -47}, {114, 114, 241}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 242}, {98, 116, 71}, {117, 117, 243}, {118, 122, 71}, },
            {{36, 95, -10}, {97, 106, 71}, {107, 107, 244}, {108, 122, 71}, },
            {{36, 113, -47}, {114, 114, 245}, {115, 122, 71}, },
            {{36, 104, -52}, {105, 105, 246}, {106, 107, 71}, {108, 108, 247}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 248}, {117, 122, 71}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{48, 57, 249}, {65, 70, 250}, {97, 102, 251}, },
            {{102, 102, 252}, },
            {{78, 78, 253}, },
            {{36, 36, 254}, {46, 46, 66}, {48, 57, 255}, {65, 90, 256}, {92, 92, 257}, {95, 95, 258}, {97, 122, 259}, },
            {{36, 122, -162}, },
            {{32, 32, 260}, {34, 34, 261}, {35, 35, 262}, {39, 39, 263}, {46, 46, 264}, {92, 92, 265}, {98, 98, 266}, {102, 102, 267}, {110, 110, 268}, {114, 114, 269}, {116, 116, 270}, {117, 117, 271}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 272}, {65, 70, 273}, {97, 102, 274}, },
            {},
            {{0, 65535, -75}, },
            {{0, 41, 275}, {42, 42, 179}, {43, 46, 275}, {47, 47, 276}, {48, 65535, 275}, },
            {{0, 65535, -76}, },
            {{0, 65535, -76}, },
            {{0, 65535, -76}, },
            {{0, 32, -76}, {33, 41, 180}, {42, 42, 277}, {43, 46, 180}, {47, 47, 278}, {48, 65535, 180}, },
            {{48, 57, 184}, {69, 69, 279}, {70, 70, 280}, {101, 101, 281}, {102, 102, 282}, },
            {{48, 70, -80}, {76, 76, 77}, {97, 102, 187}, },
            {{48, 102, -187}, },
            {{48, 102, -187}, },
            {{105, 105, 283}, },
            {{105, 105, 284}, },
            {},
            {{117, 117, 285}, },
            {{114, 114, 286}, },
            {{105, 105, 287}, },
            {{48, 57, 288}, {65, 70, 289}, {97, 102, 290}, },
            {{48, 102, -196}, },
            {{48, 102, -196}, },
            {{36, 115, -109}, {116, 116, 291}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 292}, {112, 122, 71}, },
            {{36, 107, -119}, {108, 108, 293}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 97, 294}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 295}, {102, 122, 71}, },
            {{36, 100, -39}, {101, 101, 296}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 98, 71}, {99, 99, 297}, {100, 122, 71}, },
            {{36, 113, -47}, {114, 114, 298}, {115, 122, 71}, },
            {{36, 114, -105}, {115, 115, 299}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 102, -130}, {103, 103, 300}, {104, 107, 71}, {108, 108, 301}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 97, 302}, {98, 122, 71}, },
            {{36, 97, -36}, {98, 98, 303}, {99, 122, 71}, },
            {{36, 95, -10}, {97, 97, 304}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 305}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 108, 71}, {109, 109, 306}, {110, 122, 71}, },
            {{36, 115, -109}, {116, 116, 307}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 308}, {102, 122, 71}, },
            {{36, 114, -105}, {115, 115, 309}, {116, 122, 71}, },
            {{36, 95, -10}, {97, 97, 310}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 311}, {98, 122, 71}, },
            {{36, 108, -214}, {109, 109, 312}, {110, 122, 71}, },
            {{36, 110, -37}, {111, 111, 313}, {112, 122, 71}, },
            {{36, 107, -119}, {108, 108, 314}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 315}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 316}, {102, 122, 71}, },
            {{36, 102, -130}, {103, 103, 317}, {104, 122, 71}, },
            {{36, 102, -130}, {103, 103, 318}, {104, 122, 71}, },
            {{36, 106, -144}, {107, 107, 319}, {108, 122, 71}, },
            {{36, 104, -52}, {105, 105, 320}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 321}, {98, 108, 71}, {109, 109, 322}, {110, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 107, -119}, {108, 108, 323}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 117, 71}, {118, 118, 324}, {119, 122, 71}, },
            {{36, 115, -109}, {116, 116, 325}, {117, 122, 71}, },
            {{36, 107, -119}, {108, 108, 326}, {109, 122, 71}, },
            {{36, 116, -115}, {117, 117, 327}, {118, 122, 71}, },
            {{36, 113, -47}, {114, 114, 328}, {115, 122, 71}, },
            {{36, 98, -205}, {99, 99, 329}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 330}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 331}, {106, 122, 71}, },
            {{36, 98, -205}, {99, 99, 332}, {100, 122, 71}, },
            {{36, 107, -119}, {108, 108, 333}, {109, 122, 71}, },
            {{36, 110, -37}, {111, 111, 334}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 335}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 336}, {102, 122, 71}, },
            {{36, 109, -40}, {110, 110, 337}, {111, 122, 71}, },
            {{36, 115, -109}, {116, 116, 338}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 99, 71}, {100, 100, 339}, {101, 122, 71}, },
            {{36, 95, -10}, {97, 97, 340}, {98, 122, 71}, },
            {{36, 103, -49}, {104, 104, 341}, {105, 122, 71}, },
            {{48, 57, 342}, {65, 70, 343}, {97, 102, 344}, },
            {{48, 102, -251}, },
            {{48, 102, -251}, },
            {{105, 105, 345}, },
            {{70, 70, 346}, {102, 102, 347}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{32, 32, 348}, {34, 34, 349}, {35, 35, 350}, {39, 39, 351}, {46, 46, 352}, {92, 92, 353}, {98, 98, 354}, {102, 102, 355}, {110, 110, 356}, {114, 114, 357}, {116, 116, 358}, {117, 117, 359}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{48, 57, 360}, {65, 70, 361}, {97, 102, 362}, },
            {{48, 57, 363}, {65, 70, 364}, {97, 102, 365}, },
            {{48, 102, -274}, },
            {{48, 102, -274}, },
            {{0, 41, 366}, {42, 42, 367}, {43, 65535, 366}, },
            {{9, 47, -3}, },
            {{0, 8, 368}, {9, 9, 369}, {10, 10, 370}, {11, 12, 368}, {13, 13, 371}, {14, 31, 368}, {32, 32, 372}, {33, 41, 368}, {42, 42, 373}, {43, 46, 368}, {47, 47, 374}, {48, 65535, 368}, },
            {{0, 65535, -185}, },
            {{43, 43, 375}, {45, 45, 376}, {48, 57, 377}, },
            {},
            {{43, 57, -281}, },
            {},
            {{110, 110, 378}, },
            {{116, 116, 379}, },
            {{103, 103, 380}, },
            {{97, 97, 381}, },
            {{115, 115, 382}, },
            {{48, 57, 383}, {65, 70, 384}, {97, 102, 385}, },
            {{48, 102, -290}, },
            {{48, 102, -290}, },
            {{36, 113, -47}, {114, 114, 386}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 387}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 388}, {102, 122, 71}, },
            {{36, 106, -144}, {107, 107, 389}, {108, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 103, -49}, {104, 104, 390}, {105, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 114, -105}, {115, 115, 391}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 116, -115}, {117, 117, 392}, {118, 122, 71}, },
            {{36, 107, -119}, {108, 108, 393}, {109, 122, 71}, },
            {{36, 108, -214}, {109, 109, 394}, {110, 122, 71}, },
            {{36, 113, -47}, {114, 114, 395}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 108, -214}, {109, 109, 396}, {110, 122, 71}, },
            {{36, 109, -40}, {110, 110, 397}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 398}, {102, 122, 71}, },
            {{36, 107, -119}, {108, 108, 399}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 400}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 401}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 97, 402}, {98, 122, 71}, },
            {{36, 113, -47}, {114, 114, 403}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 404}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 116, -115}, {117, 117, 405}, {118, 122, 71}, },
            {{36, 117, -233}, {118, 118, 406}, {119, 122, 71}, },
            {{36, 113, -47}, {114, 114, 407}, {115, 122, 71}, },
            {{36, 116, -115}, {117, 117, 408}, {118, 122, 71}, },
            {{36, 92, -10}, {95, 95, 409}, {97, 122, 71}, },
            {{36, 95, -10}, {97, 97, 410}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 411}, {102, 122, 71}, },
            {{36, 104, -52}, {105, 105, 412}, {106, 122, 71}, },
            {{36, 113, -47}, {114, 114, 413}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 414}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 415}, {106, 122, 71}, },
            {{36, 104, -52}, {105, 105, 416}, {106, 122, 71}, },
            {{36, 98, -205}, {99, 99, 417}, {100, 122, 71}, },
            {{36, 103, -49}, {104, 104, 418}, {105, 122, 71}, },
            {{36, 100, -39}, {101, 101, 419}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 118, 71}, {119, 119, 420}, {120, 122, 71}, },
            {{36, 114, -105}, {115, 115, 421}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 422}, {112, 122, 71}, },
            {{36, 116, -115}, {117, 117, 423}, {118, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 115, -109}, {116, 116, 424}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{48, 57, 425}, {65, 70, 426}, {97, 102, 427}, },
            {{48, 102, -344}, },
            {{48, 102, -344}, },
            {{110, 110, 428}, },
            {},
            {},
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{48, 57, 429}, {65, 70, 430}, {97, 102, 431}, },
            {{48, 57, 432}, {65, 70, 433}, {97, 102, 434}, },
            {{48, 102, -362}, },
            {{48, 102, -362}, },
            {{48, 57, 435}, {65, 70, 436}, {97, 102, 437}, },
            {{48, 102, -365}, },
            {{48, 102, -365}, },
            {{0, 65535, -277}, },
            {{0, 41, 275}, {42, 42, 367}, {43, 65535, -181}, },
            {{0, 65535, -279}, },
            {{0, 65535, -279}, },
            {{0, 8, 178}, {9, 9, 438}, {10, 10, 370}, {11, 12, 178}, {13, 13, 371}, {14, 31, 178}, {32, 32, 439}, {33, 41, 178}, {42, 42, 179}, {43, 46, 178}, {47, 47, 440}, {48, 65535, 178}, },
            {{0, 65535, -372}, },
            {{0, 65535, -279}, },
            {{0, 8, 441}, {9, 9, 442}, {10, 10, 443}, {11, 12, 441}, {13, 13, 444}, {14, 31, 441}, {32, 32, 445}, {33, 41, 441}, {42, 42, 373}, {43, 46, 441}, {47, 47, 446}, {48, 65535, 441}, },
            {{0, 41, -279}, {42, 42, 447}, {43, 46, 368}, {47, 47, 448}, {48, 65535, 368}, },
            {{48, 57, 377}, },
            {{48, 57, 377}, },
            {{48, 57, 377}, {70, 70, 280}, {102, 102, 282}, },
            {{105, 105, 449}, },
            {{62, 62, 450}, },
            {{104, 104, 451}, },
            {{109, 109, 452}, },
            {{58, 58, 453}, },
            {{48, 57, 454}, {65, 70, 455}, {97, 102, 456}, },
            {{48, 102, -385}, },
            {{48, 102, -385}, },
            {{36, 95, -10}, {97, 97, 457}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 458}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 459}, {98, 122, 71}, },
            {{36, 111, -113}, {112, 112, 460}, {113, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -119}, {108, 108, 461}, {109, 122, 71}, },
            {{36, 100, -39}, {101, 101, 462}, {102, 122, 71}, },
            {{36, 104, -52}, {105, 105, 463}, {106, 122, 71}, },
            {{36, 108, -214}, {109, 109, 464}, {110, 122, 71}, },
            {{36, 110, -37}, {111, 111, 465}, {112, 122, 71}, },
            {{36, 99, -248}, {100, 100, 466}, {101, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 108, -214}, {109, 109, 467}, {110, 122, 71}, },
            {{36, 109, -40}, {110, 110, 468}, {111, 122, 71}, },
            {{36, 101, -44}, {102, 102, 469}, {103, 122, 71}, },
            {{36, 103, -49}, {104, 104, 470}, {105, 122, 71}, },
            {{36, 111, -113}, {112, 112, 471}, {113, 122, 71}, },
            {{36, 100, -39}, {101, 101, 472}, {102, 122, 71}, },
            {{36, 113, -47}, {114, 114, 473}, {115, 122, 71}, },
            {{36, 107, -119}, {108, 108, 474}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 475}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 476}, {117, 122, 71}, },
            {{36, 98, -205}, {99, 99, 477}, {100, 122, 71}, },
            {{36, 98, -205}, {99, 99, 478}, {100, 122, 71}, },
            {{36, 109, -40}, {110, 110, 479}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 480}, {98, 122, 71}, },
            {{36, 98, -205}, {99, 99, 481}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 482}, {117, 122, 71}, },
            {{36, 113, -47}, {114, 114, 483}, {115, 122, 71}, },
            {{36, 114, -105}, {115, 115, 484}, {116, 122, 71}, },
            {{36, 114, -105}, {115, 115, 485}, {116, 122, 71}, },
            {{36, 104, -52}, {105, 105, 486}, {106, 122, 71}, },
            {{36, 118, -336}, {119, 119, 487}, {120, 122, 71}, },
            {{36, 95, -10}, {97, 97, 488}, {98, 122, 71}, },
            {{36, 104, -52}, {105, 105, 489}, {106, 122, 71}, },
            {{48, 57, 490}, {65, 70, 491}, {97, 102, 492}, },
            {{48, 102, -427}, },
            {{48, 102, -427}, },
            {{105, 105, 493}, },
            {{48, 57, 494}, {65, 70, 495}, {97, 102, 496}, },
            {{48, 102, -431}, },
            {{48, 102, -431}, },
            {{48, 57, 497}, {65, 70, 498}, {97, 102, 499}, },
            {{48, 102, -434}, },
            {{48, 102, -434}, },
            {{48, 57, 500}, {65, 70, 501}, {97, 102, 502}, },
            {{48, 102, -437}, },
            {{48, 102, -437}, },
            {{0, 65535, -372}, },
            {{0, 65535, -372}, },
            {{0, 41, 178}, {42, 42, 503}, {43, 46, 178}, {47, 47, 504}, {48, 65535, 178}, },
            {{0, 8, 505}, {9, 9, 506}, {10, 10, 507}, {11, 12, 505}, {13, 13, 508}, {14, 31, 505}, {32, 32, 509}, {33, 41, 505}, {42, 42, 510}, {43, 46, 505}, {47, 47, 511}, {48, 65535, 505}, },
            {{0, 65535, -443}, },
            {{0, 8, 366}, {9, 9, 512}, {10, 10, 507}, {11, 12, 366}, {13, 13, 508}, {14, 31, 366}, {32, 32, 513}, {33, 41, 366}, {42, 42, 367}, {43, 46, 366}, {47, 47, 514}, {48, 65535, 366}, },
            {{0, 65535, -445}, },
            {{0, 65535, -443}, },
            {{0, 65535, -185}, },
            {{0, 8, 515}, {9, 9, 516}, {10, 10, 517}, {11, 12, 515}, {13, 13, 518}, {14, 31, 515}, {32, 32, 519}, {33, 41, 515}, {42, 42, 373}, {43, 46, 515}, {47, 47, 520}, {48, 65535, 515}, },
            {{0, 65535, -376}, },
            {{116, 116, 521}, },
            {},
            {{116, 116, 522}, },
            {{101, 101, 523}, },
            {},
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 98, -205}, {99, 99, 524}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 525}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 526}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 527}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 528}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 98, -205}, {99, 99, 529}, {100, 122, 71}, },
            {{36, 110, -37}, {111, 111, 530}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 531}, {111, 122, 71}, },
            {{36, 114, -105}, {115, 115, 532}, {116, 122, 71}, },
            {{36, 100, -39}, {101, 101, 533}, {102, 122, 71}, },
            {{36, 98, -205}, {99, 99, 534}, {100, 122, 71}, },
            {{36, 95, -10}, {97, 97, 535}, {98, 122, 71}, },
            {{36, 110, -37}, {111, 111, 536}, {112, 122, 71}, },
            {{36, 114, -105}, {115, 115, 537}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 538}, {98, 122, 71}, },
            {{36, 115, -109}, {116, 116, 539}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 120, 71}, {121, 121, 540}, {122, 122, 71}, },
            {{36, 100, -39}, {101, 101, 541}, {102, 122, 71}, },
            {{36, 115, -109}, {116, 116, 542}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -119}, {108, 108, 543}, {109, 122, 71}, },
            {{36, 104, -52}, {105, 105, 544}, {106, 122, 71}, },
            {{36, 101, -44}, {102, 102, 545}, {103, 122, 71}, },
            {{36, 110, -37}, {111, 111, 546}, {112, 122, 71}, },
            {{36, 118, -336}, {119, 119, 547}, {120, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 548}, {102, 122, 71}, },
            {{36, 109, -40}, {110, 110, 549}, {111, 122, 71}, },
            {{36, 107, -119}, {108, 108, 550}, {109, 122, 71}, },
            {{36, 107, -119}, {108, 108, 551}, {109, 122, 71}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{116, 116, 552}, },
            {{48, 57, 553}, {65, 70, 554}, {97, 102, 555}, },
            {{48, 102, -496}, },
            {{48, 102, -496}, },
            {{48, 57, 556}, {65, 70, 557}, {97, 102, 558}, },
            {{48, 102, -499}, },
            {{48, 102, -499}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 41, 559}, {42, 42, 179}, {43, 46, 559}, {47, 47, 560}, {48, 65535, 559}, },
            {{0, 65535, -279}, },
            {{0, 65535, -443}, },
            {{0, 65535, -443}, },
            {{0, 65535, -445}, },
            {{0, 65535, -445}, },
            {{0, 65535, -443}, },
            {{0, 41, -375}, {42, 42, 510}, {43, 65535, -375}, },
            {{0, 41, -443}, {42, 42, 561}, {43, 46, 505}, {47, 47, 562}, {48, 65535, 505}, },
            {{0, 65535, -445}, },
            {{0, 65535, -445}, },
            {{0, 41, 366}, {42, 42, 563}, {43, 46, 366}, {47, 47, 564}, {48, 65535, 366}, },
            {{0, 8, 565}, {9, 9, 566}, {10, 10, 567}, {11, 12, 565}, {13, 13, 568}, {14, 31, 565}, {32, 32, 569}, {33, 41, 565}, {42, 42, 570}, {43, 46, 565}, {47, 47, 571}, {48, 65535, 565}, },
            {{0, 65535, -517}, },
            {{0, 8, 572}, {9, 9, 573}, {10, 10, 567}, {11, 12, 572}, {13, 13, 568}, {14, 31, 572}, {32, 32, 574}, {33, 41, 572}, {42, 42, 575}, {43, 46, 572}, {47, 47, 576}, {48, 65535, 572}, },
            {{0, 65535, -519}, },
            {{0, 65535, -517}, },
            {{0, 65535, -376}, },
            {{62, 62, 577}, },
            {{101, 101, 578}, },
            {{116, 116, 579}, },
            {{36, 115, -109}, {116, 116, 580}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 581}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 582}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 583}, {106, 122, 71}, },
            {{36, 109, -40}, {110, 110, 584}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 585}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 586}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 587}, {102, 122, 71}, },
            {{36, 98, -205}, {99, 99, 588}, {100, 122, 71}, },
            {{36, 101, -44}, {102, 102, 589}, {103, 122, 71}, },
            {{36, 118, -336}, {119, 119, 590}, {120, 122, 71}, },
            {{36, 120, -477}, {121, 121, 591}, {122, 122, 71}, },
            {{36, 104, -52}, {105, 105, 592}, {106, 122, 71}, },
            {{36, 111, -113}, {112, 112, 593}, {113, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 594}, {102, 122, 71}, },
            {{36, 104, -52}, {105, 105, 595}, {106, 122, 71}, },
            {{36, 109, -40}, {110, 110, 596}, {111, 122, 71}, },
            {{36, 111, -113}, {112, 112, 597}, {113, 122, 71}, },
            {{36, 109, -40}, {110, 110, 598}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 599}, {106, 122, 71}, },
            {{36, 109, -40}, {110, 110, 600}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 601}, {106, 122, 71}, },
            {{36, 100, -39}, {101, 101, 602}, {102, 122, 71}, },
            {{121, 121, 603}, },
            {{48, 57, 604}, {65, 70, 605}, {97, 102, 606}, },
            {{48, 102, -555}, },
            {{48, 102, -555}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{0, 41, 572}, {42, 42, 575}, {43, 65535, 572}, },
            {{0, 65535, -372}, },
            {{0, 41, -449}, {42, 42, 570}, {43, 65535, -449}, },
            {{0, 65535, -513}, },
            {{0, 41, 559}, {42, 42, 575}, {43, 65535, -505}, },
            {{0, 65535, -443}, },
            {{0, 65535, -517}, },
            {{0, 65535, -517}, },
            {{0, 65535, -519}, },
            {{0, 65535, -519}, },
            {{0, 65535, -517}, },
            {{0, 41, -375}, {42, 42, 570}, {43, 65535, -375}, },
            {{0, 41, -517}, {42, 42, 607}, {43, 46, 565}, {47, 47, 608}, {48, 65535, 565}, },
            {{0, 65535, -561}, },
            {{0, 65535, -519}, },
            {{0, 65535, -519}, },
            {{0, 41, 275}, {42, 42, 575}, {43, 65535, -181}, },
            {{0, 41, 572}, {42, 42, 609}, {43, 46, 572}, {47, 47, 610}, {48, 65535, 572}, },
            {},
            {{120, 120, 611}, },
            {{101, 101, 612}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 613}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 614}, {111, 122, 71}, },
            {{36, 109, -40}, {110, 110, 615}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 616}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 617}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 618}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 619}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 620}, {102, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 621}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 622}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 623}, {102, 122, 71}, },
            {{36, 99, -248}, {100, 100, 624}, {101, 122, 71}, },
            {{36, 109, -40}, {110, 110, 625}, {111, 122, 71}, },
            {{36, 117, -233}, {118, 118, 626}, {119, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 627}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 628}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 629}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 630}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{70, 102, -255}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{36, 122, -162}, },
            {{0, 65535, -563}, },
            {{0, 65535, -573}, },
            {{0, 65535, -565}, },
            {{0, 65535, -517}, },
            {{99, 99, 631}, },
            {{114, 114, 632}, },
            {{36, 109, -40}, {110, 110, 633}, {111, 122, 71}, },
            {{36, 115, -109}, {116, 116, 634}, {117, 122, 71}, },
            {{36, 117, -233}, {118, 118, 635}, {119, 122, 71}, },
            {{36, 115, -109}, {116, 116, 636}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 637}, {112, 122, 71}, },
            {{36, 114, -105}, {115, 115, 638}, {116, 122, 71}, },
            {{36, 101, -44}, {102, 102, 639}, {103, 122, 71}, },
            {{36, 104, -52}, {105, 105, 640}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 641}, {117, 122, 71}, },
            {{36, 113, -47}, {114, 114, 642}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 117, -233}, {118, 118, 643}, {119, 122, 71}, },
            {{36, 110, -37}, {111, 111, 644}, {112, 122, 71}, },
            {{36, 95, -10}, {97, 121, 71}, {122, 122, 645}, },
            {{36, 98, -205}, {99, 99, 646}, {100, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 117, -233}, {118, 118, 647}, {119, 122, 71}, },
            {{101, 101, 648}, },
            {{48, 57, 649}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 650}, {112, 122, 71}, },
            {{36, 110, -37}, {111, 111, 651}, {112, 122, 71}, },
            {{36, 113, -47}, {114, 114, 652}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 653}, {111, 122, 71}, },
            {{36, 98, -205}, {99, 99, 654}, {100, 122, 71}, },
            {{36, 113, -47}, {114, 114, 655}, {115, 122, 71}, },
            {{36, 110, -37}, {111, 111, 656}, {112, 122, 71}, },
            {{36, 106, -144}, {107, 107, 657}, {108, 122, 71}, },
            {{36, 100, -39}, {101, 101, 658}, {102, 122, 71}, },
            {{36, 103, -49}, {104, 104, 659}, {105, 122, 71}, },
            {{36, 110, -37}, {111, 111, 660}, {112, 122, 71}, },
            {{112, 112, 661}, },
            {{48, 57, 649}, {58, 58, 662}, },
            {{36, 106, -144}, {107, 107, 663}, {108, 122, 71}, },
            {{36, 113, -47}, {114, 114, 664}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 117, -233}, {118, 118, 665}, {119, 122, 71}, },
            {{36, 103, -49}, {104, 104, 666}, {105, 122, 71}, },
            {{36, 95, -10}, {97, 97, 667}, {98, 122, 71}, },
            {{36, 106, -144}, {107, 107, 668}, {108, 122, 71}, },
            {{36, 100, -39}, {101, 101, 669}, {102, 122, 71}, },
            {{36, 99, -248}, {100, 100, 670}, {101, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 106, -144}, {107, 107, 671}, {108, 122, 71}, },
            {{116, 116, 672}, },
            {},
            {{36, 100, -39}, {101, 101, 673}, {102, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 674}, {112, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 120, -477}, {121, 121, 675}, {122, 122, 71}, },
            {{36, 100, -39}, {101, 101, 676}, {102, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 677}, {102, 122, 71}, },
            {{105, 105, 678}, },
            {{36, 122, -10}, },
            {{36, 106, -144}, {107, 107, 679}, {108, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{111, 111, 680}, },
            {{36, 100, -39}, {101, 101, 681}, {102, 122, 71}, },
            {{110, 110, 682}, },
            {{36, 122, -10}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 0, 0, 0, 0, -1, -1, -1, 95, 79, 76, 73, 69, 70, 91, 89, 63, 90, 72, 92, 98, 98, 71, 66, 84, 75, 82, -1, 95, 67, -1, 68, 78, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 64, 77, 65, -1, 81, -1, 100, -1, -1, -1, -1, -1, -1, 95, -1, 95, 95, -1, 95, 95, -1, -1, 0, -1, 98, 98, -1, -1, 74, 86, 85, -1, -1, 80, 83, 87, -1, -1, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 39, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 60, 95, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 93, 93, -1, 93, 93, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, 94, -1, -1, 0, 0, 0, 0, 99, 98, 98, 98, -1, -1, 88, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 62, 32, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 21, 95, 95, 95, 95, 44, 45, 48, 95, 95, 95, 95, 49, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, -1, -1, -1, 99, 93, 93, 93, -1, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, -1, -1, -1, -1, -1, 0, 0, 0, -1, 99, -1, 99, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 18, 30, 95, 20, 95, 33, 34, 95, 95, 95, 95, 12, 95, 95, 95, 95, 95, 59, 38, 95, 95, 95, 95, 22, 95, 95, 95, 95, 58, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 16, 95, 61, -1, -1, -1, -1, 99, 99, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, 99, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 31, 14, 95, 95, 95, 95, 95, 95, 95, 2, 23, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 19, 95, 95, 95, 95, 95, 55, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 95, -1, -1, 96, 95, 95, 95, 95, 95, 95, 95, 95, 24, 95, 95, 95, 95, 95, 95, 95, 95, 95, 3, 95, 95, 95, 95, 95, 4, 50, 95, 7, 95, 95, 95, 56, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 95, 95, 17, 95, 35, 95, 95, 95, 27, 95, 95, 95, 95, 95, 95, 95, 95, 6, 95, 95, 95, 95, 95, 95, 95, 26, 95, 95, -1, -1, -1, -1, 93, 93, 93, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -1, 95, -1, -1, 1, 95, 95, 95, 95, 95, 95, 95, 95, 42, 95, 46, 95, 95, 95, 95, 95, 11, 95, 95, 95, 95, 10, 99, 93, 93, 93, 0, 0, -1, 0, -1, -1, 95, 95, 95, 95, 95, 95, 95, 15, 95, 95, 25, 5, 95, 95, 95, 95, 9, 95, -1, -1, 13, 29, 95, 95, 95, 28, 40, 95, 95, 95, 95, 95, 95, 95, 95, -1, -1, 95, 95, 37, 95, 95, 95, 95, 95, 95, 54, 95, -1, 96, 95, 36, 95, 43, 95, 95, 52, 8, 95, -1, 53, 95, 47, 51, 57, -1, 95, -1, 41, 96, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
