package de.upb.pga3.panda2.test.extension.lvl2b.analyzer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import soot.SootClass;
import soot.SootMethod;

import com.google.common.collect.Iterables;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.analyzer.AnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.analyzer.ManifestPermissionComparerLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.graphgenerator.GraphGeneratorLvl2b;

/**
 *
 * @author Anand
 *
 */
public class ManifestPermissionComparerLvl2bTest {
	Enhancer enhancer;
	EnhancedInput enhInput;
	GraphGeneratorLvl1 ggl1;
	AnalysisGraph agl1;
	AnalyzerLvl1 azl1;
	AnalysisResultLvl1 anRstl1;
	ResultInput resultIP;
	GraphGeneratorLvl2b ggl2b;

	AnalysisGraph agl2b;
	ManifestPermissionComparerLvl2b mpc;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		SootAdapter.getInstance().reinitSoot();

		final Path p = Paths.get("test_resources/SimpleRequiredInternetP.apk");

		this.enhancer = new Enhancer();
		this.enhInput = (EnhancedInput) this.enhancer.enhance(p);

		this.ggl1 = new GraphGeneratorLvl1();
		this.agl1 = this.ggl1.generateGraph(this.enhInput, p);
		this.azl1 = new AnalyzerLvl1();
		this.anRstl1 = new AnalysisResultLvl1(this.agl1);
		this.anRstl1 = (AnalysisResultLvl1) this.azl1.analyze(this.agl1, null);
		final List<AnalysisResult> anaList = new ArrayList<AnalysisResult>();
		anaList.add(this.anRstl1);
		this.resultIP = new ResultInput(anaList);

		this.ggl2b = new GraphGeneratorLvl2b();
		this.agl2b = this.ggl2b.generateGraph(this.resultIP, p);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void manifestPermissioncomparertest() {

		this.agl2b = new AnalysisGraph(this.resultIP);

		this.mpc = new ManifestPermissionComparerLvl2b(false);

		final AnalysisResultLvl2b analysisResult = this.mpc.compare(this.agl2b);
		assertNotNull(analysisResult);

		final List<AnalysisResult> anaRstLst = this.resultIP.getResults();
		for (final AnalysisResult anaRst : anaRstLst) {

			final AnalysisResultLvl1 ana = (AnalysisResultLvl1) anaRst;
			final EnhancedInput ei = (EnhancedInput) ana.getAnalysisGraph().getInput();

			Permission permissionClass = null;
			Permission permissionMethod = null;
			for (final SootClass classOrComponent : ei.getAppClasses()) {
				if (classOrComponent.toString().contains("MainActivity")) {
					permissionClass = Iterables.get(ei.getPermissionsFor(classOrComponent), 0);
					for (final SootMethod method : classOrComponent.getMethods()) {
						if (method.toString().contains("onCreate")) {
							permissionMethod = Iterables.get(ei.getPermissionsFor(method), 0);
							break;
						}
					}
					break;
				}
			}

			assertNotNull(permissionClass);
			assertEquals("android.permission.INTERNET", permissionClass.getName());
			assertNotNull(permissionMethod);
			assertEquals("android.permission.INTERNET", permissionMethod.getName());
			assertEquals(true, ei.getMaybeMoreList().isEmpty());
		}
	}

}
