package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import soot.Unit;

/**
 * The class <code>SourceAndSinkComputerTest</code> contains tests for the class
 * <code>{@link SourceAndSinkComputer}</code>.
 *
 * @generatedBy CodePro at 15.02.16 11:24
 * @author Fabian
 * @author Monika
 * @version $Revision: 1.0 $
 */
public class SourceAndSinkComputerTest {
	/**
	 * Run the SourceAndSinkComputer() constructor test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:24
	 */
	@Test
	public void testSourceAndSinkComputer_1() throws Exception {

		final SourceAndSinkComputer result = new SourceAndSinkComputer();

		// add additional test code here
		assertNotNull(result);
	}

	/**
	 * Run the Map<Permission, List<Unit>> computeSinks(List
	 * <Unit>,EnhancedInput) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:24
	 */
	@Test
	public void testComputeSourcesAndSinks() throws Exception {
		final SourceAndSinkComputer fixture = new SourceAndSinkComputer();

		final AnalysisGraph graph = TestCodeFactory.createAnalysisGraph("test_resources/ExpoAppLvl2a.apk");
		final Object[] lstNode = graph.getNodes().toArray();
		final List<Unit> lstNodeUnit = new ArrayList<>();
		if (lstNode != null && lstNode.length > 0) {
			for (final Object obj : lstNode) {
				if (obj instanceof Unit) {
					lstNodeUnit.add((Unit) obj);
				}
			}
		}
		final Map<Permission, List<Unit>> sinks = fixture.computeSinks(lstNodeUnit, (EnhancedInput) graph.getInput());
		final Map<Permission, List<Unit>> sources = fixture.computeSources(lstNodeUnit,
				(EnhancedInput) graph.getInput());
		assertNotNull(sinks);
		assertNotNull(sources);
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 15.02.16 11:24
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 15.02.16 11:24
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 15.02.16 11:24
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(SourceAndSinkComputerTest.class);
	}
}