package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.extension.lvl2a.ParamType;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import soot.EquivalentValue;
import soot.ErroneousType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.baf.internal.BArrayLengthInst;
import soot.jimple.internal.JCaughtExceptionRef;
import soot.util.StationaryArrayList;

/**
 * The class <code>ParameterNodeTest</code> contains tests for the class
 * <code>{@link ParameterNode}</code>.
 *
 * @generatedBy CodePro at 15.02.16 11:25
 * @author Fabian
 * @author Monika
 * @version $Revision: 1.0 $
 */
public class ParameterNodeTest {
	/**
	 * Run the ParameterNode(Value,ParamType,SootMethod,int) constructor test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testParameterNode_1() throws Exception {
		final Value inParamValue = new EquivalentValue(new JCaughtExceptionRef());
		final ParamType inType = ParamType.values()[1];
		final SootMethod inMethod = new SootMethod("", new StationaryArrayList(), ErroneousType.v());
		final int inIndex = 1;

		final ParameterNode result = new ParameterNode(inParamValue, inType, inMethod, inIndex);

		// add additional test code here
		assertNotNull(result);
		assertEquals(true, result.belongsToMethod());
		assertEquals(null, result.getCorrespondingUnit());
		assertEquals(false, result.belongsToUnit());
		assertEquals(1, result.getIndex());
	}

	/**
	 * Run the ParameterNode(Value,ParamType,Unit,int) constructor test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testParameterNode_2() throws Exception {
		final Value inParamValue = new EquivalentValue(new JCaughtExceptionRef());
		final ParamType inType = ParamType.valueOf(ParamType.ACTUAL_IN.toString());
		final Unit inInvokeStmnt = new BArrayLengthInst();
		final int inIndex = 1;

		final ParameterNode result = new ParameterNode(inParamValue, inType, inInvokeStmnt, inIndex);

		// add additional test code here
		assertNotNull(result);
		assertEquals(false, result.belongsToMethod());
		assertEquals(null, result.getCorrespondingMethod());
		assertEquals(true, result.belongsToUnit());
		assertEquals(1, result.getIndex());
	}

	/**
	 * Run the boolean belongsToMethod() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testBelongsToMethod_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final boolean result = fixture.belongsToMethod();

		// add additional test code here
		assertEquals(false, result);
	}

	/**
	 * Run the boolean belongsToUnit() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testBelongsToUnit_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final boolean result = fixture.belongsToUnit();

		// add additional test code here
		assertEquals(true, result);
	}

	/**
	 * Run the SootMethod getCorrespondingMethod() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testGetCorrespondingMethod_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final SootMethod result = fixture.getCorrespondingMethod();

		// add additional test code here
		assertEquals(null, result);
	}

	/**
	 * Run the Unit getCorrespondingUnit() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testGetCorrespondingUnit_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final Unit result = fixture.getCorrespondingUnit();

		// add additional test code here
		assertNotNull(result);
		assertEquals(true, result.fallsThrough());
		assertEquals(false, result.branches());
		assertEquals(-1, result.getJavaSourceStartLineNumber());
		assertEquals(-1, result.getJavaSourceStartColumnNumber());
	}

	/**
	 * Run the int getIndex() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testGetIndex_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final int result = fixture.getIndex();

		// add additional test code here
		assertEquals(1, result);
	}

	/**
	 * Run the Value getParameterValue() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testGetParameterValue_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final Value result = fixture.getParameterValue();

		// add additional test code here
		assertNotNull(result);
		assertEquals(1729, result.equivHashCode());
	}

	/**
	 * Run the ParamType getType() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Test
	public void testGetType_1() throws Exception {
		final ParameterNode fixture = new ParameterNode(new EquivalentValue(new JCaughtExceptionRef()),
				ParamType.ACTUAL_IN, new BArrayLengthInst(), 1);

		final ParamType result = fixture.getType();

		// add additional test code here
		assertNotNull(result);
		assertEquals("ACTUAL_IN", result.name());
		assertEquals("ACTUAL_IN", result.toString());
		assertEquals(0, result.ordinal());
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@Before
	public void setUp() throws Exception {
		// add additional set up code here
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 15.02.16 11:25
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(ParameterNodeTest.class);
	}
}