/**
 *
 */
package de.upb.pga3.panda2.test.extension.lvl2a;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.ConfigManager;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.NodeLinkerLvl2a;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.util.Chain;

/**
 *
 * @author nptsy
 */
public class JUnitTestControlFlowGraph {

	@Before
	public void startTesting() {
		SootAdapter.getInstance().reinitSoot();
	}

	@After
	public void endTesting() {

	}

	@Test
	public void testExcludedPath() {
		final List<String> lstExclPacks = ConfigManager.getInstance().getExcludedPackages();
		for (final String exlPack : lstExclPacks) {
			System.err.println(exlPack);
		}
	}

	@Test
	public void testExcludedPackagesClasses() {
		final File f = new File("test_resources/TestSimpleAndroidApp.apk");
		A3XMLParser.getInstance().fetchData(f.toPath().toString());
		SootAdapter.getInstance().init(f.toPath());

		final Chain<SootClass> sootClasses = Scene.v().getApplicationClasses();
		for (final SootClass sootClass : sootClasses) {
			G.v().out.println(sootClass.toString());
		}
	}

	@Test
	public void testControlFlowGraph() {

		final Path testAPK = Paths.get("test_resources/ExpoAppLvl2a.apk");
		A3XMLParser.getInstance().fetchData(testAPK.toString());
		SootAdapter.getInstance().init(testAPK);

		final Enhancer e = new Enhancer();
		final Input ei = e.enhance(testAPK);
		final AnalysisGraphLvl2a graph = new AnalysisGraphLvl2a(ei);
		// final AnalysisGraphLvl2a graph = new AnalysisGraphLvl2a(new
		// EnhancedInput("SlidingTilePuzzle",
		// "adsfasdfasd7a5dfa5s7d8f5a87s6df",
		// A3XMLParser.getInstance().getManifestInformation()));
		final NodeLinkerLvl2a nodeLinker = new NodeLinkerLvl2a();
		nodeLinker.link(graph);
	}
}
