package de.upb.pga3.panda2.test.extension.lvl2a;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a.DetailLevelLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ComparisonAnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;

/**
 * The class <code>ComparisonAnalysisResultLvl2aTest</code> contains tests for
 * the class <code>{@link ComparisonAnalysisResultLvl2a}</code>.
 *
 * @generatedBy CodePro at 23.02.16 17:01
 * @author Monika
 * @version $Revision: 1.0 $
 */
public class ComparisonAnalysisResultLvl2aTest {
	/**
	 * Run the ComparisonAnalysisResultLvl2a(AnalysisResultLvl2a) constructor
	 * test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testComparisonAnalysisResultLvl2a_1() throws Exception {

		final AnalysisResultLvl2a inRes = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a result = new ComparisonAnalysisResultLvl2a(inRes);

		assertNotNull(result);
	}

	/**
	 * Run the
	 * ComparisonAnalysisResultLvl2a(AnalysisResultLvl2a,AnalysisResultLvl2a)
	 * constructor test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testComparisonAnalysisResultLvl2a_2() throws Exception {
		final AnalysisResultLvl2a inCurRes = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a result = new ComparisonAnalysisResultLvl2a(inCurRes);

		assertNotNull(result);
	}

	/**
	 * Run the boolean addNewPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAddNewPath_1() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");
		final AnalysisResultLvl2a inPrevRes = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final FlowPath inNewPath = inPrevRes.getPaths().iterator().next();

		final boolean result = fixture.addNewPath(inNewPath);

		assertTrue(result);
	}

	/**
	 * Run the boolean addNewPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testAddNewPath_3() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final FlowPath inNewPath = null;

		final boolean result = fixture.addNewPath(inNewPath);

		assertTrue(result);
	}

	/**
	 * Run the boolean addRemovedPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testAddRemovedPath_1() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");
		final AnalysisResultLvl2a inPrevRes = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);
		final FlowPath inRemovedPath = inPrevRes.getPaths().iterator().next();

		final boolean result = fixture.addRemovedPath(inRemovedPath);
		assertTrue(result);
	}

	/**
	 * Run the boolean addRemovedPath(FlowPath) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testAddRemovedPath_3() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);
		final FlowPath inRemovedPath = null;

		final boolean result = fixture.addRemovedPath(inRemovedPath);

		assertTrue(result);
	}

	/**
	 * Run the void createFilters() method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testCreateAndGetFilters() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		fixture.createFilters();
		final List<String> result = fixture.getFilters();

		assertNotNull(result);
	}

	/**
	 * Run the String getGraphicalResult(DetailLevel,List<String>,boolean)
	 * method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetGraphicalResult_1() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final DetailLevel inDetailLvl = DetailLevelLvl2a.RES_TO_RES;
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result = fixture.getGraphicalResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result);
	}

	/**
	 * Run the String getTextualResult(DetailLevel,List<String>,boolean) method
	 * test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Test
	public void testGetTextualResult_Resource() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final DetailLevel inDetailLvl = DetailLevelLvl2a.RES_TO_RES;
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result);
	}

	@Test
	public void testGetTextualResult_Component() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final DetailLevel inDetailLvl = DetailLevelLvl2a.COMPONENT;
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result);
	}

	@Test
	public void testGetTextualResult_Method() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final DetailLevel inDetailLvl = DetailLevelLvl2a.METHOD;
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result);
	}

	@Test
	public void testGetTextualResult_Statement() throws Exception {
		final AnalysisResultLvl2a analysisResultLvl2a = (AnalysisResultLvl2a) TestCodeFactory
				.createAnalysisResult("test_resources/ExpoAppLvl2a.apk");

		final ComparisonAnalysisResultLvl2a fixture = new ComparisonAnalysisResultLvl2a(analysisResultLvl2a);

		final DetailLevel inDetailLvl = DetailLevelLvl2a.STATEMENT;
		final List<String> inFilters = fixture.getFilters();
		final boolean inShowStats = true;

		final String result = fixture.getTextualResult(inDetailLvl, inFilters, inShowStats);
		assertNotNull(result);
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@Before
	public void setUp() throws Exception {
		// add additional set up code here
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 23.02.16 17:01
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(ComparisonAnalysisResultLvl2aTest.class);
	}
}