package de.upb.pga3.panda2.test.extension.lvl1.analyzer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.analyzer.AnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;

/**
 *
 * @author Anand
 *
 */
public class AnalyzerLvl1Test {
	Enhancer enhancer1;
	Enhancer enhancer2;
	EnhancedInput enhInput1;
	EnhancedInput enhInput2;
	GraphGeneratorLvl1 ggl1;
	GraphGeneratorLvl1 ggl2;
	AnalysisGraph ag1;
	AnalysisGraph ag2;
	AnalyzerLvl1 az1;
	AnalyzerLvl1 az2;
	AnalysisResultLvl1 anRst1;
	AnalysisResultLvl1 anRst2;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {

		final Path p1 = Paths.get("test_resources/SimpleIntents.apk");
		final Path p2 = Paths.get("test_resources/AllExpImpIntent.apk");
		this.enhancer1 = new Enhancer();
		this.enhInput1 = (EnhancedInput) this.enhancer1.enhance(p1);
		this.enhancer2 = new Enhancer();
		this.enhInput2 = (EnhancedInput) this.enhancer2.enhance(p2);
		this.ggl1 = new GraphGeneratorLvl1();
		this.ggl2 = new GraphGeneratorLvl1();
		this.ag1 = this.ggl1.generateGraph(this.enhInput1, p1);
		this.ag2 = this.ggl2.generateGraph(this.enhInput2, p2);
		this.az1 = new AnalyzerLvl1();
		this.az2 = new AnalyzerLvl1();
		// this.anRst2 = new AnalysisResultLvl1(this.ag2);
		this.anRst2 = (AnalysisResultLvl1) this.az2.analyze(this.ag2, null);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void analyzertest() {

		// this.anRst1 = new AnalysisResultLvl1(this.ag1);
		this.anRst1 = (AnalysisResultLvl1) this.az1.analyze(this.ag1, null);
		final List<DetailLevel> actualDetailLevelList = this.anRst1.getDetailLevels();
		assertEquals(true, actualDetailLevelList.get(2).toString().equals("CLASS"));
		assertNotNull(this.anRst1);
	}

}
