package de.upb.pga3.panda2.test.extension.lvl1;

import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.Before;
import org.junit.Test;

import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.IntentAnalyzerLvl1;

/**
 *
 * @author Anand
 *
 */
public class IntentAnalyzerLvl1Test {
	IntentAnalyzerLvl1 intentAnalyzer;

	@Before
	public void before() {
		final Path apkFile = Paths.get("test_resources/SimpleIntents.apk");
		final Enhancer enhancer = new Enhancer();
		final EnhancedInput enhancedInput = (EnhancedInput) enhancer.enhance(apkFile);
		this.intentAnalyzer = new IntentAnalyzerLvl1(enhancedInput);
	}

	private static Unit findStmt(final String className, final String methodName, final String unitCharSeq,
			final EnhancedInput ei) {
		Unit u = null;
		for (final SootClass componentOrClass : ei.getAppClasses()) {
			if (componentOrClass.getName().toString().contains(className)) {
				for (final SootMethod method : componentOrClass.getMethods()) {
					if (method.getName().toString().contains(methodName)) {
						if (!componentOrClass.isInterface()) {
							final Body body = method.retrieveActiveBody();
							for (final Unit stm : body.getUnits()) {
								if (stm.toString().contains(unitCharSeq)) {
									System.out.println(stm);
									u = stm;
								}
							}
						}
					}
				}
			}
		}
		return u;
	}

	@Test
	public void Intentanalyzerlvl1test() {

		final Unit testStmt = findStmt("MainActivity", "launch_explicit", "(android.content.Context,java.lang.Class)",
				(EnhancedInput) (this.intentAnalyzer.getGraph().getInput()));

		this.intentAnalyzer.analyzeExplicitIntents();
		assertNotNull(this.intentAnalyzer.getGraph().getOutgoingTransitions(testStmt));

		//
		// // System.out.println(intentAnalyzer.);
		//
		// final Transition[] outgoingTransitions =
		// this.intentAnalyzer.getGraph().getOutgoingTransitions(testStmt)
		// .toArray(new Transition[0]);
		//
		// final boolean targetReached = ((SootClass)
		// (outgoingTransitions[0].getTarget())).getName().toString()
		// .contains("com.mycompany.simpleintents.HelloActivity");
		//
		// assertNotNull(outgoingTransitions);
		// assertEquals(true, targetReached);

	}
}