package de.upb.pga3.panda2.test.extension.lvl1;

import static org.junit.Assert.assertNotNull;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultLeafLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTreeLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;

/**
 *
 * @author Anand
 *
 */
public class AnalysisResultLvl1Test {
	Enhancer enhancer;
	EnhancedInput enhInput;
	GraphGeneratorLvl1 ggl;
	AnalysisGraph ag;
	AnalysisResultLvl1 anRst1;
	AnalysisResultLvl1 anRst2;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {

	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		final Path p = Paths.get("test_resources/SimpleIntents.apk");
		this.enhancer = new Enhancer();
		this.enhInput = (EnhancedInput) this.enhancer.enhance(p);
		this.ggl = new GraphGeneratorLvl1();
		this.ag = this.ggl.generateGraph(this.enhInput, p);
		this.anRst1 = new AnalysisResultLvl1(this.ag);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void getApptest() {
		final ResultLeafLvl1 result = new ResultLeafLvl1("demo");
		this.anRst1.setApp(result);
		final ResultLeafLvl1 getResult = this.anRst1.getApp();
		assertNotNull(getResult);

	}

	@Test
	public void getComponentstest() {
		final ResultTreeLvl1 result = new ResultTreeLvl1();
		this.anRst1.setComponents(result);
		final ResultTreeLvl1 getResult = this.anRst1.getComponents();
		assertNotNull(getResult);

	}

	@Test
	public void getClassestest() {
		final ResultTreeLvl1 result = new ResultTreeLvl1();
		this.anRst1.setClasses(result);
		final ResultTreeLvl1 getResult = this.anRst1.getClasses();
		assertNotNull(getResult);

	}

	@Test
	public void getMethodstest() {
		final ResultTreeLvl1 result = new ResultTreeLvl1();
		this.anRst1.setMethods(result);
		final ResultTreeLvl1 getResult = this.anRst1.getMethods();
		assertNotNull(getResult);

	}

}
