package de.upb.pga3.panda2.test.extension;

import static org.junit.Assert.assertEquals;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;

/**
 *
 * @author Arjya
 * @author Abhinav
 *
 */
public class EnhancerTest {

	Enhancer enhancer;
	Enhancer enhancer1;
	Enhancer enhancer2;
	EnhancedInput enhInput;
	EnhancedInput enhInput1;
	EnhancedInput enhInput2;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		final Path p = Paths.get("test_resources/OnlyExplicit.apk");
		final Path p1 = Paths.get("test_resources/OnlyImplicit.apk");
		final Path p2 = Paths.get("test_resources/SimpleIntents.apk");

		this.enhancer = new Enhancer();
		this.enhInput = (EnhancedInput) this.enhancer.enhance(p);

		this.enhancer1 = new Enhancer();
		this.enhInput1 = (EnhancedInput) this.enhancer1.enhance(p1);

		this.enhancer2 = new Enhancer();
		this.enhInput2 = (EnhancedInput) this.enhancer2.enhance(p2);

	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void enhanceExplicittest() {
		assertEquals("onlyexplicit", this.enhInput.getAppName());
	}

	@Test
	public void enhanceExplicitPermissiontest() {
		assertEquals(0, this.enhInput.getPermissions().size());
	}

	@Test
	public void enhanceImplicittest() {
		assertEquals("onlyimplicit", this.enhInput1.getAppName());
	}

	@Test
	public void enhanceImplicitPermissiontest() {
		assertEquals(0, this.enhInput1.getPermissions().size());
	}

	@Test
	public void enhanceSimpleIntentAppNametest() {
		assertEquals("simpleintents", this.enhInput2.getAppName());
	}

	@Test
	public void enhanceSimpleIntentPermissiontest() {
		assertEquals(0, this.enhInput2.getPermissions().size());
	}

}
