package de.upb.pga3.panda2.test.core.services;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.SootAdapter.SootPhase;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.ARSCParser;
import de.upb.pga3.panda2.core.services.ARSCParser.AbstractResource;
import de.upb.pga3.panda2.core.services.ARSCParser.ResPackage;
import de.upb.pga3.panda2.core.services.ARSCParser.ResType;
import de.upb.pga3.panda2.core.services.LayoutBinaryParser;
import de.upb.pga3.panda2.core.services.XMLAttribute;
import de.upb.pga3.panda2.core.services.XMLDocument;
import de.upb.pga3.panda2.core.services.XMLHandler;
import de.upb.pga3.panda2.core.services.XMLLayoutParser;
import de.upb.pga3.panda2.core.services.XMLNamespace;
import de.upb.pga3.panda2.core.services.XMLNode;
import soot.Transform;

/**
 * The class <code>XMLDocumentTest</code> contains tests for the class
 * <code>{@link XMLDocument}</code>.
 *
 * @generatedBy CodePro at 29/02/16 16:33
 * @author RamKumar
 * @version $Revision: 1.0 $
 */
public class XMLDocumentTest {

	String apkfile;
	XMLLayoutParser layoutParser;

	/**
	 * Run the XMLDocument() constructor test.
	 *
	 * @generatedBy CodePro at 29/02/16 16:33
	 */
	@Test
	public void testXMLDocument_1() throws Exception {

		SootAdapter.getInstance().reinitSoot();

		A3XMLParser.getInstance().fetchData(this.apkfile);
		SootAdapter.getInstance().init(Paths.get(this.apkfile));

		final XMLLayoutParser laypars = A3XMLParser.getInstance().getLayoutParser();
		final Transform trans = new Transform("wjtp.laypars", laypars);
		SootAdapter.getInstance().addTransformer(trans, SootPhase.WJTP);
		assertNotNull(laypars.getLayoutCallbackMethods());

		final XMLDocument result = new XMLDocument();
		assertNotNull(result);
		// add additional test code here

		final ARSCParser arscpars = A3XMLParser.getInstance().getArscParser();
		assertNotNull(arscpars.getPackages());
		assertNotNull(arscpars.getGlobalStringPool());
		assertNull(arscpars.findResource(205587256));

		for (final ResPackage respk : arscpars.getPackages()) {
			assertNotNull(respk.getPackageId());
			assertNotNull(respk.getPackageName());
			assertNotNull(respk.getDeclaredTypes());
			for (final ResType rest : respk.getDeclaredTypes()) {
				assertNotNull(rest.getAllResources());
				for (final AbstractResource abrs : rest.getAllResources()) {
					assertNotNull(abrs.getResourceName());
					assertNotNull(abrs.getResourceID());

				}

				assertNull(rest.getResourceByName("activity_main.xml"));
				assertNotNull(rest.getTypeName());
				assertNull(rest.getFirstResource("activity_main.xml"));
				assertNull(rest.getFirstResource(25888972));

			}
		}

		final File apkFile = new File(this.apkfile);
		if (!apkFile.exists()) {
			throw new RuntimeException("File " + this.apkfile + " doesn't exist.");
		}

		try {
			final ZipFile zFile = new ZipFile(apkFile);
			final Enumeration<?> entries = zFile.entries();
			while (entries.hasMoreElements()) {
				final ZipEntry entry = (ZipEntry) entries.nextElement();
				final String entryName = entry.getName();
				parseLayoutFile(entryName, zFile.getInputStream(entry));
			}

		} catch (final ZipException e) {
			e.printStackTrace();
		} catch (final IOException e) {
			e.printStackTrace();
		}

	}

	private void parseLayoutFile(final String fileName, final InputStream iStream) {

		if (!fileName.startsWith("res/layout")) {
			return;
		}
		if (!fileName.endsWith(".xml")) {
			return;
		}

		if (!fileName.startsWith("res/layout")) {
			return;
		}

		try {
			final XMLHandler handler = new XMLHandler(iStream, new LayoutBinaryParser());
			final XMLNode root = handler.getDocument().getRootNode();
			assertNotNull(root);

			final XMLDocument doc = handler.getDocument();
			assertNotNull(doc.getNamespaces());

			for (final XMLNamespace ns : doc.getNamespaces()) {
				assertNotNull(ns.getLine());
			}
			assertNotNull(root.getChildrenWithTag("activity"));
			root.setNameSpace("dummy namespace");
			assertNotNull(root.getNameSpace());
			root.setAdded(true);
			assertNull(root.getAttribute("domain"));
			assertNotNull(root.getParent());

			assertSame(false, root.hasAttribute("name"));
			assertNotNull(root.getAttributes());
			final Map<String, XMLAttribute<?>> attributes = root.getAttributes();
			for (final String attrName : attributes.keySet()) {
				final XMLAttribute attr = attributes.get(attrName);
				assertNotNull(attr.getValue());
				assertNotNull(attr.getResourceId());
				assertNotNull(attr.getAttributeType());
				assertNotNull(attr.getType());
			}

			final XMLAttribute attr1 = new XMLAttribute("Dummy1", 0, "dummynamespace");
			final XMLAttribute attr2 = new XMLAttribute("Dummy2", 205587, 0, "dummynamespace");
			final XMLAttribute attr3 = new XMLAttribute("Dummy3", 205587, 0, "dummynamespace", true);
			assertTrue(!attr1.equals(attr2));
			attr3.setValue(25);
			attr2.setAdded(true);
			attr1.setNameSpace("dummyns");
			root.addAttribute(attr1);
			root.addAttribute(attr2);
			root.addAttribute(attr3);

			final XMLNode child1 = new XMLNode("ChildNode", "dummyns", root, true);

			root.addSiblingAfter(child1);
			root.addSiblingBefore(child1);
			root.addChild(child1);
			child1.setParent(root);
			assertNotNull(root.getChildren());

		} catch (final Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *             if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 29/02/16 16:33
	 */
	@Before
	public void setUp() throws Exception {
		// add additional set up code here

		this.apkfile = "test_resources/Lvl2AMoreTestCases/WordSwirlV2.apk";

	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *             if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 29/02/16 16:33
	 */
	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args
	 *            the command line arguments
	 *
	 * @generatedBy CodePro at 29/02/16 16:33
	 */
	public static void main(final String[] args) {
		new org.junit.runner.JUnitCore().run(XMLDocumentTest.class);
	}
}