package de.upb.pga3.panda2.test.core.services;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.nio.file.Path;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.ManifestXMLParser;

/**
 *
 * @author Arjya
 * @author Abhinav
 *
 */
public class ManifestXMLParserTest {

	ManifestXMLParser mp;
	EnhancedInput ei;
	Path p;
	String path;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {

		this.path = "test_resources/SimpleIntents.apk";
		this.mp = new ManifestXMLParser(this.path);

	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void getLstProviderstest() {

		final List<String> providers;
		providers = this.mp.getLstProviders();
		assertNull(providers);
	}

	@Test
	public void getLstReceiverstest() {

		final List<String> receivers;
		receivers = this.mp.getLstProviders();
		assertNull(receivers);
	}

	@Test
	public void getLstServicestest() {

		final List<String> services;
		services = this.mp.getLstProviders();
		assertNull(services);
	}

	@Test
	public void getLstActivitiestest() {

		final List<String> activities;
		activities = this.mp.getLstActivities();

		assertNotNull(activities);

	}

	@Test
	public void getLstActivitiesValuetest() {

		final List<String> activities;
		activities = this.mp.getLstActivities();

		assertEquals("com.mycompany.simpleintents.MainActivity", activities.get(0).toString());

	}

	@Test
	public void getLstActivitiesNegativetest() {

		final List<String> activities;
		activities = this.mp.getLstActivities();

		assertNotEquals("com.mycompany.simpleintents", activities.get(1).toString());

	}

	@Test
	public void getManifestInfotest() {

		final ManifestInfo mi = this.mp.getManifestInfo();
		assertNotNull(mi);

	}

	@Test
	public void getManifestInfoValuetest() {

		final String packageName = this.mp.getManifestInfo().getPackage();
		assertEquals("com.mycompany.simpleintents", packageName);

	}

	@Test
	public void getIntentFilterstest() {

		final List<IntentFilter> filters = this.mp.getManifestInfo().getIntentFilters();
		assertNull(filters);

	}

	@Test
	public void getIntentFiltersValuetest() {

		final List<IntentFilter> filters = this.mp.getIntentFilters();
		assertEquals("android.intent.action.MAIN", filters.get(0).getActionName());

	}

	@Test
	public void getIntentFiltersNegativetest() {

		final List<IntentFilter> filters = this.mp.getIntentFilters();
		assertNotEquals("android.intent.action", filters.get(0).getActionName());

	}

	@Test
	public void versionCodeValuetest() {

		final String versionCode = this.mp.getManifestInfo().getVersionCode();
		assertEquals("1", versionCode);

	}

	@Test
	public void versionNameValuetest() {

		final String versionName = this.mp.getManifestInfo().getVersionName();
		assertEquals("1.0", versionName);

	}

	@Test
	public void versionNameCodePackageValuetest() {

		this.mp.getManifestInfo().setVersionName("2.0");
		this.mp.getManifestInfo().setVersionCode("2");
		this.mp.getManifestInfo().setPackage("MAIN");
		assertEquals("2.0", this.mp.getManifestInfo().getVersionName());
		assertEquals("2", this.mp.getManifestInfo().getVersionCode());
		assertEquals("MAIN", this.mp.getManifestInfo().getPackage());

	}
}
