package de.upb.pga3.panda2.test.core.services;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.GlobalVariable;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.utilities.Constants;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;

/**
 * Junit test for global variable analysis
 * 
 * @author nptsy
 */
public class GlobalVariableTest {

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testGeneral() {
		final Enhancer enhancer = new Enhancer();
		final File f = new File("test_resources/IntentExample.apk");
		final EnhancedInput ei = (EnhancedInput) enhancer.enhance(f.toPath());

		final StatementAnalyzer stmtAnalyzer = CoreServices.getStatementAnalyzerInstance();
		boolean isAndroidComponent = false;
		final SootClass[] classes = ei.getAppClasses();
		// map that contains global variables of a class
		final Map<String, GlobalVariable> mapGlobalVars = new HashMap<>();

		for (final SootClass c : classes) {
			isAndroidComponent = ei.isAndroidComponent(c);
			final List<SootMethod> methods = c.getMethods();

			// in case of android component
			if (isAndroidComponent) {
				for (final SootMethod m : methods) {
					try {
						if (isConstructor(m)) {
							final Body body = m.retrieveActiveBody();
							stmtAnalyzer.extractGlobalVars(body, ei, mapGlobalVars);
						}
					} catch (final RuntimeException e) {
					}
				}
			}
		}

		if (!mapGlobalVars.isEmpty()) {
			final Collection<GlobalVariable> colVars = mapGlobalVars.values();
			for (final GlobalVariable var : colVars) {
				final String type = var.getType();
				assertNotNull(type);

				final boolean isString = var.isInTypeOf("java.lang.String");
				if (isString) {
					assertTrue(isString);
				} else {
					assertFalse(isString);
				}

				final String varName = var.getVarName();
				if (varName != null) {
					assertNotNull(varName);
				} else {
					assertNull(varName);
				}

				final SootClass sc = var.getParentClass();
				if (sc != null) {
					assertNotNull(sc);
				} else {
					assertNull(sc);
				}

				final String varStr = var.toString();
				assertNotNull(varStr);

				final boolean isEqual = var.equals(new GlobalVariable(sc));
				assertFalse(isEqual);

				final List<String> lstValues = var.getValues();
				assertNull(lstValues);
			}
		}
	}

	private static boolean isConstructor(final SootMethod inSootMethod) {
		if (inSootMethod != null) {
			final String signature = inSootMethod.getSignature();
			if (signature.contains(Constants.KEY_WORD_CONSTRUCTOR)) {
				return true;
			}
		}
		return false;
	}
}
