package de.upb.pga3.panda2.test.core.services;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;

import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.XMLParser;

/**
 *
 * @author Anand
 *
 */
public class A3XMLParserTest {

	String apkPath = "";
	A3XMLParser a3p;
	XMLParser xp;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		this.apkPath = "test_resources/SimpleIntents.apk";
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void getAppNametest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final String appName = this.xp.getAppName();
		assertEquals("simpleintents", appName);

	}

	@Test
	public void getAppNameNegativetest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final String appName = this.xp.getAppName();
		assertNotEquals("Simple", appName);

	}

	@Test
	public void getFingerprinttest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final String appName = this.xp.getFingerprint();
		assertEquals("24ca4ad37466d705700ec339e048f0e5", appName);

	}

	@Test
	public void getFingerprintNegativetest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final String appName = this.xp.getFingerprint();
		assertNotEquals("dummy", appName);

	}

	@Test
	public void getUsesPermissiontest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final List<String> usesPer = this.xp.getUsesPermission();
		assertEquals(0, usesPer.size());

	}

	@Test
	public void getIntentFilterstest() {
		this.xp = this.a3p.getInstance();
		this.xp.fetchData(this.apkPath);
		final List<IntentFilter> intentFil = this.xp.getIntentFilters();
		assertEquals(1, intentFil.size());

	}

}
