package de.upb.pga3.panda2.test.core.datastructures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Map;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.upb.pga3.panda2.core.datastructures.IntentFilter;

/**
 * @author Anand
 *
 */
public class IntentFilterTest {

	String mStrTargetNameT = "TName";
	String mStrActionNameT = "AName";
	String mStrCategoryNameT = "CName";
	Map<String, String> mMapDataT;
	IntentFilter iT = new IntentFilter(this.mStrTargetNameT);

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void addDatatest() {
		this.iT.setActionName(this.mStrActionNameT);
		this.iT.setCategoryName(this.mStrCategoryNameT);
		this.iT.addData("1", "ABC");
		this.mMapDataT = this.iT.getMapData();
		assertNotNull(this.mMapDataT);

	}

	@Test
	public void getTargetNametest() {
		this.iT.setActionName(this.mStrActionNameT);
		this.iT.setCategoryName(this.mStrCategoryNameT);
		final String targetName = this.iT.getTargetName();
		assertEquals("TName", targetName);

	}

	@Test
	public void getActionNametest() {
		this.iT.setActionName(this.mStrActionNameT);
		this.iT.setCategoryName(this.mStrCategoryNameT);
		final String actionName = this.iT.getActionName();
		assertEquals("AName", actionName);

	}

	@Test
	public void getCategoryNametest() {
		this.iT.setActionName(this.mStrActionNameT);
		this.iT.setCategoryName(this.mStrCategoryNameT);
		final String categoryName = this.iT.getCategoryName();
		assertEquals("CName", categoryName);

	}

}
