package de.upb.pga3.panda2.test.client.core.datastructures.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;
import de.upb.pga3.panda2.client.core.datastructures.validation.ToolSpecificOptionConverter;

/**
 * Test cases related to ToolSpecificConverter class.
 *
 * @author Sriram
 *
 */
public class ToolSpecificConverterTest {

	public ToolSpecificConverterTest() {
	}

	String toolSpecificValue;
	String toolSpecificInvalidValue;
	ToolSpecificOptionConverter toolSpecificOptionConverter;
	ToolSpecificOption tsOption;

	@Before
	public void setUp() throws Exception {
		this.toolSpecificValue = "LOAD";
		this.toolSpecificInvalidValue = "LOADING";
		this.toolSpecificOptionConverter = new ToolSpecificOptionConverter();
	}

	@Test
	public void convertTest() {
		this.tsOption = this.toolSpecificOptionConverter.convert(this.toolSpecificValue);
		assertNotNull(this.tsOption);
	}

	@Test
	public void convertValuetest() {
		this.tsOption = this.toolSpecificOptionConverter.convert(this.toolSpecificValue);
		assertEquals(ToolSpecificOption.LOAD, this.tsOption);
	}

	@Test(expected = ParameterException.class)
	public void convertNegativetest() {
		this.tsOption = this.toolSpecificOptionConverter.convert(this.toolSpecificInvalidValue);
	}

}
