package de.upb.pga3.panda2.test.client.core.datastructures.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultViewConverter;

/**
 *
 * @author Anand
 *
 */
public class ResultViewConverterTest {

	private String resultView;
	private String resultViewInvalid;

	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		this.resultView = "textual";
		this.resultViewInvalid = "dummy";
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void converttest() {
		final ResultViewConverter rvc = new ResultViewConverter();
		final ResultView rv = rvc.convert(this.resultView);
		assertNotNull(rv);
	}

	@Test
	public void convertValuetest() {
		final ResultViewConverter rvc = new ResultViewConverter();
		final ResultView rv = rvc.convert(this.resultView);
		assertEquals(ResultView.TEXTUAL, rv);
	}

	@Test
	public void convertNegetivetest() {
		final ResultViewConverter rvc = new ResultViewConverter();

		this.exception.expect(ParameterException.class);
		final ResultView rv = rvc.convert(this.resultViewInvalid);
		assertNull(rv);

	}

}
