package de.upb.pga3.panda2.test.client.core.datastructures.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultRepresentationConverter;

/**
 *
 * @author Anand
 *
 */
public class ResultRepresentationConverterTest {

	String resultRep;
	String resultRepInvalid;

	@Rule
	public final ExpectedException exception = ExpectedException.none();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		this.resultRep = "view";
		this.resultRepInvalid = "dummy";
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void converttest() {
		final ResultRepresentationConverter rrc = new ResultRepresentationConverter();
		final ResultRepresentation rr = rrc.convert(this.resultRep);
		assertNotNull(rr);
	}

	@Test
	public void convertValuetest() {
		final ResultRepresentationConverter rrc = new ResultRepresentationConverter();
		final ResultRepresentation rr = rrc.convert(this.resultRep);
		assertEquals(ResultRepresentation.VIEW, rr);
	}

	@Test
	public void convertNegetivetest() {
		final ResultRepresentationConverter rrc = new ResultRepresentationConverter();

		this.exception.expect(ParameterException.class);
		final ResultRepresentation rr = rrc.convert(this.resultRepInvalid);
		assertNull(rr);

	}

}
