package de.upb.pga3.panda2.test.client.core.datastructures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultViewConverter;

/**
 *
 * @author Arjya
 *
 */
public class ResultViewTest {

	ResultView rv;

	@Before
	public void setUp() throws Exception {

		final ResultViewConverter rvc = new ResultViewConverter();
		this.rv = rvc.convert("T");
	}

	@Test
	public void getValuestest() {
		assertNotNull(this.rv.getValues().size());
	}

	@Test
	public void getValuesValuetest() {
		assertEquals("T", this.rv.getValues().get(0).toString());
	}

	@Test
	public void getValuesNegativetest() {
		assertNotEquals("somevalues", this.rv.getValues().get(0).toString());
	}

	@Test
	public void fromStringtest() {
		assertNotNull(ResultView.fromString("T"));
	}

	@Test
	public void fromStringValuetest() {
		assertEquals("TEXTUAL", ResultView.fromString("T").toString());
	}

	@Test
	public void fromStringNegativetest() {
		assertNull(ResultView.fromString(""));
	}

}
