package de.upb.pga3.panda2.test.client.core.datastructures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultRepresentationConverter;

/**
 *
 * @author Arjya
 *
 */
public class ResultRepresentationTest {

	ResultRepresentation rr;

	@Before
	public void setUp() throws Exception {

		final ResultRepresentationConverter rc = new ResultRepresentationConverter();
		this.rr = rc.convert("SAVE");
	}

	@Test
	public void getValuestest() {
		assertNotNull(this.rr.getValues().size());
	}

	@Test
	public void getValuesValuetest() {
		assertEquals("S", this.rr.getValues().get(0).toString());
	}

	@Test
	public void getValuesNegativetest() {
		assertNotEquals("dummy", this.rr.getValues().get(0).toString());
	}

	@Test
	public void fromStringtest() {
		assertNotNull(ResultRepresentation.fromString("S"));
	}

	@Test
	public void fromStringValuetest() {
		assertEquals("SAVE", ResultRepresentation.fromString("S").toString());
	}

	@Test
	public void fromStringNegativetest() {
		assertNull(ResultRepresentation.fromString(""));
	}

}
