package de.upb.pga3.panda2.test.client.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.UserInput;

/**
 *
 * @author Arjya
 *
 */
public class UserInputTest {

	UserInput ui;
	List<String> initialInputList;
	List<String> nonNativeAppsList;
	String selCompInput;

	@Before
	public void setUp() throws Exception {
		this.ui = new UserInput();
		this.initialInputList = Arrays.asList("test_resources/OnlyExplicit.apk");
		this.nonNativeAppsList = Arrays.asList("test_resources/OnlyImplicit.apk");
		this.selCompInput = "dummy";
		this.ui.setSelectedInitialInput(this.initialInputList);
		this.ui.setSelectedComparisonInput(this.selCompInput);
		this.ui.setSelectedNonNativeapps(this.nonNativeAppsList);
	}

	@Test
	public void createAPKFilesForInitialInputtest() {
		this.ui.createAPKFilesForInitialInput();
		assertEquals(1, this.ui.getInitialInputAPKFiles().size());
	}

	@Test
	public void createPreviousAnalysisResultFiletest() {
		this.ui.createPreviousAnalysisResultFile();
		assertNotNull(this.ui.getPreviousAnalysisResultFile());
	}

	@Test
	public void createAPKFilesForNonNativeAppstest() {
		this.ui.createAPKFilesForNonNativeApps();
		assertEquals(1, this.ui.getSelectedNonNativeapps().size());
	}

}
