package de.upb.pga3.panda2.test.client.core;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.ClientGUI;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.extension.lvl1.DetailLevelLvl1;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a.DetailLevelLvl2a;
import de.upb.pga3.panda2.extension.lvl2b.DetailLevelLvl2b;

/**
 * Test cases for ClientGUI class.
 *
 * @author Abhinav
 *
 */
public class ClientGUITest {

	UserInput ui;
	List<String> initialInputList;
	List<String> nonNativeAppsList;
	String selCompInput;
	ClientGUI clientGUI = new ClientGUI();

	@Before
	public void setUp() throws Exception {
		this.ui = new UserInput();
		this.initialInputList = Arrays.asList("test_resources/OnlyExplicit.apk");
		this.nonNativeAppsList = Arrays.asList("test_resources/OnlyImplicit.apk");
		this.selCompInput = "dummy";
		this.ui.setSelectedInitialInput(this.initialInputList);
		this.ui.setSelectedComparisonInput(this.selCompInput);
		this.ui.setSelectedNonNativeapps(this.nonNativeAppsList);
		this.clientGUI.setUserInput(this.ui);
	}

	@Test
	public void getDefaultDetailLevel1test() {
		this.clientGUI.getUserInput().setLevel(AnalysisRegistry.LEVEL1);
		this.clientGUI.getUserInput().setMode(Mode.SUMMARY);
		this.clientGUI.performAnalysis();
		final List<String> selectDetailLevel1 = this.clientGUI.getDetailLevels();

		assertEquals(selectDetailLevel1.size(), DetailLevelLvl1.values().length);

	}

	@Test
	public void getDefaultDetailLevel2atest() {
		this.clientGUI.getUserInput().setLevel(AnalysisRegistry.LEVEL2A);
		this.clientGUI.getUserInput().setMode(Mode.SUMMARY);
		this.clientGUI.performAnalysis();
		final List<String> selectDetailLevel2a = this.clientGUI.getDetailLevels();
		assertEquals(selectDetailLevel2a.size(), DetailLevelLvl2a.values().length);

	}

	@Test
	public void getDefaultDetailLevel2btest() {
		this.clientGUI.getUserInput().setLevel(AnalysisRegistry.LEVEL2B);
		this.clientGUI.getUserInput().setMode(Mode.SUMMARY);
		this.clientGUI.getUserInput().setLevelSpecificMode(LevelSpecificMode.ALL);
		this.clientGUI.performAnalysis();
		final List<String> selectDetailLevel2b = this.clientGUI.getDetailLevels();
		assertEquals(selectDetailLevel2b.size(), DetailLevelLvl2b.values().length);

	}

	@Test
	public void convertMessagesToHTMLString() {
		this.clientGUI.getUserInput().setLevel(AnalysisRegistry.LEVEL1);
		this.clientGUI.getUserInput().setMode(Mode.SUMMARY);
		this.clientGUI.performAnalysis();
		final String messagesString = this.clientGUI.convertMessagesToHTMLString();
		assertNotNull(messagesString);

	}

}
