package de.upb.pga3.panda2.test.client.core;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.core.ClientCommandLine;

/**
 * Test cases for ClientCommandLine class.
 *
 * @author Sriram
 *
 */
public class ClientCommandLineTest {

	String[] initialArguments;
	String[] initialArguments1;
	String[] initialArguments2;
	String[] initialArguments3;
	String[] ArgumentsNoParam;

	@Before
	public void setUp() throws Exception {
		this.initialArguments = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v",
				"textual" };

		this.initialArguments1 = new String[] { "-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view",
				"-v", "graphical" };

		this.initialArguments2 = new String[] { "-opt", "help" };

		this.initialArguments3 = new String[] { "-opt", "load", "-fp", "test_resources/anaResult1.pa2" };

		this.ArgumentsNoParam = new String[] {};
	}

	@Test
	public void validateCommandLineInputArgumentstest() {
		final ClientCommandLine cmdLine = new ClientCommandLine();
		final boolean isvalid = cmdLine.validateCommandLineInputArguments(this.initialArguments);
		assertEquals(true, isvalid);
	}

	@Test
	public void validateCommandLineInputArguments1test() {
		final ClientCommandLine cmdLine = new ClientCommandLine();
		final boolean isvalid = cmdLine.validateCommandLineInputArguments(this.initialArguments1);
		assertEquals(true, isvalid);
	}

	@Test
	public void validateCommandLineInputArgumentsHelptest() {
		final ClientCommandLine cmdLine = new ClientCommandLine();
		final boolean isvalid = cmdLine.validateCommandLineInputArguments(this.initialArguments2);
		assertEquals(true, isvalid);
	}

	@Test
	public void validateCommandLineInputArgumentsLoadtest() {
		final ClientCommandLine cmdLine = new ClientCommandLine();
		final boolean isvalid = cmdLine.validateCommandLineInputArguments(this.initialArguments3);
		assertEquals(true, isvalid);
	}

	@Test
	public void validateCommandLineInputArgumentsNegetivetest() {
		final ClientCommandLine cmdLine = new ClientCommandLine();
		final boolean isvalid = cmdLine.validateCommandLineInputArguments(this.ArgumentsNoParam);
		assertEquals(false, isvalid);
	}
}
