/**
 *
 */
package de.upb.pga3.panda2.test.client.cmdline;

import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import de.upb.pga3.panda2.client.cmdline.HtmlParser;

/**
 *
 * Test Case for the HtmlParser class.
 * 
 * @author Sriram
 *
 */
public class HtmlParserTest {

	String validTextualResult;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {

		this.validTextualResult = "<html> <head> <title> Sample Test </title> </head> <body> <p> This is the testing paragraph </p> </body> </html>";
	}

	/**
	 * Test method for
	 * {@link de.upb.pga3.panda2.client.cmdline.HtmlParser#parse(java.lang.String)}
	 * .
	 */
	@Test
	public void testParse() {
		HtmlParser.parse(this.validTextualResult, false);
	}

	/**
	 * Test method for
	 * {@link de.upb.pga3.panda2.client.cmdline.HtmlParser#parse(java.lang.String)}
	 * .
	 */
	@Test
	public void testParseNull() {
		HtmlParser.parse(null, false);
	}

	@Test
	public void constructorTest() {
		final HtmlParser htmlParser = new HtmlParser();
		assertNotNull(htmlParser);
	}
}
