package de.upb.pga3.panda2.utilities;

import java.util.Arrays;
import java.util.List;

/**
 * This class contains all constants that are used in the whole application
 *
 * @author nptsy
 */
public class Constants {
	// define constants for files
	public static final String MANIFEST_FILE = "AndroidManifest.xml";
	public static final String RESOURCE_FILE = "resources.asrc";
	public static final String APK_EXTENSION = ".apk";
	public static final String SAVED_RESULT_EXTENSION = ".pa2";
	public static final String RSA_EXTENSION = ".RSA";
	// public static final String SOURCE_FILE = "sources";
	// public static final String SINK_FILE = "sinks";
	public static final String SINK_FILE = "output_Sinks.txt";
	public static final String SOURCE_FILE = "output_Sources.txt";
	public static final String ANDROID_CALL_BACK_FILE = "androidcallbacks";

	// define constants for tags
	public static final String TAG_MANIFEST = "manifest";

	// -
	public static final String TAG_USES_PERMISSION = "uses-permission";
	public static final String TAG_PERMISSION = "permission";
	public static final String TAG_PERMISSION_TREE = "permission-tree";
	public static final String TAG_PERMISSION_GROUP = "permission-group";
	public static final String TAG_USES_SDK = "uses-sdk";
	public static final String TAG_USES_CONFIGURATION = "uses-configuration";
	public static final String TAG_APPLICATION = "application";
	// -

	// --
	public static final String TAG_ACTIVITY = "activity";
	public static final String TAG_ACTIVITY_ALIAS = "activity-alias";
	public static final String TAG_SERVICE = "service";
	public static final String TAG_RECEIVER = "receiver";
	public static final String TAG_PROVIDER = "provider";
	public static final String TAG_USES_LIBRARY = "uses-library";
	// --

	// ---
	public static final String TAG_META_DATA = "meta-data";
	public static final String TAG_INTENT_FILTER = "intent-filter";
	public static final String TAG_GRANT_URI_PERMISSION = "grant-uri-permission";
	public static final String TAG_PATH_PERMISSION = "path-permission";
	// ---

	// ----
	public static final String TAG_ACTION = "action";
	public static final String TAG_CATEGORY = "category";
	public static final String TAG_DATA = "data";
	// ----

	// define constants for attributes
	public static final String ATT_PACKAGE = "package";
	public static final String ATT_ANDROID_VERSION_CODE = "android:versionCode";
	public static final String ATT_ANDROID_VERSION_NAME = "android:versionName";
	public static final String ATT_ANDROID_NAME = "android:name";
	public static final String ATT_ANDROID_LABEL = "android:label";
	public static final String ATT_ANDROID_CONFGCHANGE = "android:configChanges";
	public static final String ATT_ANDROID_LAUNCHMODE = "android:launchMode";
	public static final String ATT_ANDROID_PERMISSION = "android:permission";
	public static final String ATT_ANDROID_SCHEME = "android:scheme";
	public static final String ATT_ANDROID_HOST = "android:host";
	public static final String ATT_ANDROID_PORT = "android:port";
	public static final String ATT_ANDROID_PATH = "android:path";
	public static final String ATT_ANDROID_PATH_PATTERN = "android:pathPattern";
	public static final String ATT_ANDROID_PATH_PREFIX = "android:pathPrefix";
	public static final String ATT_ANDROID_MIMETYPE = " android:mimeType";

	public static final String MD5_MODE = "MD5";
	public static final String SHA1_MODE = "SHA1";

	public static final String ANDROID_APP_ACTIVITY = "android.app.Activity";
	public static final String ANDROID_APP_SERVICE = "android.app.Service";
	public static final String ANDROID_APP_PROVIDER = "android.content.ContentProvider";
	public static final String ANDROID_APP_RECEIVER = "android.content.BroadcastReceiver";

	public static final String ACTIVITY_ONCREATE = "void onCreate(android.os.Bundle)";
	public static final String ACTIVITY_ONSTART = "void onStart()";
	public static final String ACTIVITY_ONRESUME = "void onResume()";
	public static final String ACTIVITY_ONRESTOREINSTANCESTATE = "void onRestoreInstanceState(android.os.Bundle)";
	public static final String ACTIVITY_ONPOSTCREATE = "void onPostCreate(android.os.Bundle)";
	public static final String ACTIVITY_ONPOSTRESUME = "void onPostResume()";
	public static final String ACTIVITY_ONPAUSE = "void onPause()";
	public static final String ACTIVITY_ONCREATEDESCRIPTION = "java.lang.CharSequence onCreateDescription()";
	public static final String ACTIVITY_ONSAVEINSTANCESTATE = "void onSaveInstanceState(android.os.Bundle)";
	public static final String ACTIVITY_ONSTOP = "void onStop()";
	public static final String ACTIVITY_ONRESTART = "void onRestart()";
	public static final String ACTIVITY_ONDESTROY = "void onDestroy()";

	public static final String[] METHODTYPES = { "java.lang.String", "void", "char", "byte", "short", "int", "float",
			"long", "double", "boolean" };

	public static final List<String> METHOD_TYPES = Arrays.asList(METHODTYPES);

	public static final String SERVICE_ONCREATE = "void onCreate()";
	public static final String SERVICE_ONSTART1 = "void onStart(android.content.Intent,int)";
	public static final String SERVICE_ONSTART2 = "int onStartCommand(android.content.Intent,int,int)";
	public static final String SERVICE_ONBIND = "android.os.IBinder onBind(android.content.Intent)";
	public static final String SERVICE_ONREBIND = "void onRebind(android.content.Intent)";
	public static final String SERVICE_ONUNBIND = "boolean onUnbind(android.content.Intent)";
	public static final String SERVICE_ONDESTROY = "void onDestroy()";

	public static final String GCMBASEINTENTSERVICECLASS = "com.google.android.gcm.GCMBaseIntentService";
	public static final String GCMLISTENERSERVICECLASS = "com.google.android.gms.gcm.GcmListenerService";

	public static final String GCMINTENTSERVICE_ONDELETEDMESSAGES = "void onDeletedMessages(android.content.Context,int)";
	public static final String GCMINTENTSERVICE_ONERROR = "void onError(android.content.Context,java.lang.String)";
	public static final String GCMINTENTSERVICE_ONMESSAGE = "void onMessage(android.content.Context,android.content.Intent)";
	public static final String GCMINTENTSERVICE_ONRECOVERABLEERROR = "void onRecoverableError(android.content.Context,java.lang.String)";
	public static final String GCMINTENTSERVICE_ONREGISTERED = "void onRegistered(android.content.Context,java.lang.String)";
	public static final String GCMINTENTSERVICE_ONUNREGISTERED = "void onUnregistered(android.content.Context,java.lang.String)";

	public static final String GCMLISTENERSERVICE_ONDELETEDMESSAGES = "void onDeletedMessages()";
	public static final String GCMLISTENERSERVICE_ONMESSAGERECEIVED = "void onMessageReceived(java.lang.String,android.os.Bundle)";
	public static final String GCMLISTENERSERVICE_ONMESSAGESENT = "void onMessageSent(java.lang.String)";
	public static final String GCMLISTENERSERVICE_ONSENDERROR = "void onSendError(java.lang.String,java.lang.String)";

	private static String[] gcmIntentServiceMethods = { GCMINTENTSERVICE_ONDELETEDMESSAGES, GCMINTENTSERVICE_ONERROR,
			GCMINTENTSERVICE_ONMESSAGE, GCMINTENTSERVICE_ONRECOVERABLEERROR, GCMINTENTSERVICE_ONREGISTERED,
			GCMINTENTSERVICE_ONUNREGISTERED };

	private static String[] gcmListenerServiceMethods = { GCMLISTENERSERVICE_ONDELETEDMESSAGES,
			GCMLISTENERSERVICE_ONMESSAGERECEIVED, GCMLISTENERSERVICE_ONMESSAGESENT, GCMLISTENERSERVICE_ONSENDERROR };

	public static final String BROADCAST_ONRECEIVE = "void onReceive(android.content.Context,android.content.Intent)";

	public static final String CONTENTPROVIDER_ONCREATE = "boolean onCreate()";

	public static final String APPLIFECYCLECALLBACK_ONACTIVITYSTARTED = "void onActivityStarted(android.app.Activity)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYSTOPPED = "void onActivityStopped(android.app.Activity)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYSAVEINSTANCESTATE = "void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYRESUMED = "void onActivityResumed(android.app.Activity)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYPAUSED = "void onActivityPaused(android.app.Activity)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYDESTROYED = "void onActivityDestroyed(android.app.Activity)";
	public static final String APPLIFECYCLECALLBACK_ONACTIVITYCREATED = "void onActivityCreated(android.app.Activity,android.os.Bundle)";

	public static final String PREFIX_SOURCE = "Source:";
	public static final String PREFIX_SINK = "Sink:";
	public static final String PREFIX_PERMISSION = "Permission:";

	public static final String TEMPLATE_LEVEL2A = "data/templates/level2a.html";
	public static final String REPLACED_KEY_WORD_MAIN_CONTENT = "$MAIN_CONTENT$";
	public static final String REPLACED_KEY_WORD_NOPATH = "$NUMBER_PATH$";
	public static final String REPLACED_KEY_WORD_NEWPATH = "$NEW_PATHS$";
	public static final String REPLACED_KEY_WORD_REMOVEDPATH = "$REMOVE_PATHS$";

	public static final String METHOD_START_ACTIVITY = "void startActivity(android.content.Intent)";
	public static final String METHOD_START_ACTIVITY_BUNDLE = "void startActivity(android.content.Intent,android.os.Bundle)";
	public static final String METHOD_START_ACTIVITY_FOR_RESULT = "void startActivityForResult(android.content.Intent,int)";
	public static final String METHOD_START_ACTIVITIES = "void startActivities(android.content.Intent[])";
	public static final String METHOD_START_ACTIVITIES_BUNDLE = "void startActivities(android.content.Intent[],android.os.Bundle)";
	public static final String METHOD_START_ACTIVITY_FOR_RESULT_BUNDLE = "void startActivityForResult(android.content.Intent,int,android.os.Bundle)";
	public static final String METHOD_START_ACTIVITY_FROM_CHILD = "void startActivityFromChild(android.app.Activity,android.content.Intent,int)";
	public static final String METHOD_START_ACTIVITY_FROM_CHILD_BUNDLE = "void startActivityFromChild(android.app.Activity,android.content.Intent,int,android.os.Bundle)";
	public static final String METHOD_START_ACTIVITY_FROM_FRAGMENT = "void startActivityFromFragment(android.app.Fragment,android.content.Intent,int)";
	public static final String METHOD_START_ACTIVITY_FROM_FRAGMENT_BUNDLE = "void startActivityFromFragment(android.app.Fragment,android.content.Intent,int,android.os.Bundle)";
	public static final String METHOD_START_ACTIVITY_IF_NEEDED = "boolean startActivityIfNeeded(android.content.Intent,int)";
	public static final String METHOD_START_ACTIVITY_IF_NEEDED_BUNDLE = "boolean startActivityIfNeeded(android.content.Intent,int,android.os.Bundle)";
	public static final String METHOD_START_NEXT_MATCHING_ACTIVITY = "boolean startNextMatchingActivity(android.content.Intent)";
	public static final String METHOD_START_NEXT_MATCHING_ACTIVITY_BUNDLE = "boolean startNextMatchingActivity(android.content.Intent,android.os.Bundle)";

	public static final String METHOD_START_SERVICE = "android.content.ComponentName startService(android.content.Intent)";
	public static final String METHOD_BIND_SERVICE = "boolean bindService(android.content.Intent,android.content.ServiceConnection,int)";

	public static final String METHOD_SEND_BROADCAST_STR = "void sendBroadcast(android.content.Intent,java.lang.String)";
	public static final String METHOD_SEND_BROADCAST = "void sendBroadcast(android.content.Intent)";
	public static final String METHOD_SEND_ORDERED_BROADCAST = "void sendOrderedBroadcast(android.content.Intent,java.lang.String)";
	public static final String METHOD_SEND_ORDERED_BROADCAST_BUNDLE = "void sendOrderedBroadcast(android.content.Intent,java.lang.String,android.content.BroadcastReceiver,android.os.Handler,int,java.lang.String,android.os.Bundle)";
	public static final String METHOD_SEND_STICKY_BROADCAST = "void sendStickyBroadcast(android.content.Intent)";
	public static final String METHOD_SEND_STICKY_ORDERED_BROADCAST = "void sendStickyOrderedBroadcast(android.content.Intent,android.content.BroadcastReceiver,android.os.Handler,int,java.lang.String,android.os.Bundle)";

	// still have more methods for launching an intent
	public static final String METHOD_SET_RESULT1 = "void setResult(int,android.content.Intent)";
	public static final String METHOD_SET_RESULT2 = "void setResult(int)";

	public static final String METHOD_ON_ACTIVITY_RESULT = "void onActivityResult(int,int,android.content.Intent)";
	public static final String METHOD_CONSTRUCTOR_INTENT1 = "android.content.Intent: void <init>()";
	public static final String METHOD_CONSTRUCTOR_INTENT2 = "android.content.Intent: void <init>(java.lang.String)";
	public static final String METHOD_CONSTRUCTOR_INTENT3 = "android.content.Intent: void <init>(java.lang.String,android.net.Uri)";
	public static final String METHOD_CONSTRUCTOR_INTENT4 = "android.content.Intent: void <init>(android.content.Intent)";
	public static final String METHOD_CONSTRUCTOR_INTENT5 = "android.content.Intent: void <init>(android.content.Context,java.lang.Class)";
	public static final String METHOD_CONSTRUCTOR_INTENT6 = "android.content.Intent: void <init>(java.lang.String,android.net.Uri,android.content.Context,java.lang.Class)";
	public static final String METHOD_DECLARED_INTENT = "new android.content.Intent";
	public static final String METHOD_SET_ACTION = "android.content.Intent: android.content.Intent setAction(java.lang.String)";
	public static final String METHOD_SET_CLASS = "android.content.Intent: android.content.Intent setClass(android.content.Context,java.lang.Class)";
	public static final String METHOD_SET_CLASSNAME1 = "android.content.Intent: android.content.Intent setClassName(android.content.Context,java.lang.String)";
	public static final String METHOD_SET_CLASSNAME2 = "android.content.Intent: android.content.Intent setClassName(java.lang.String,java.lang.String)";

	public static final String KEY_WORD_INTENT = "android.content.Intent";
	public static final String KEY_WORD_CLASS = "java.lang.Class";
	public static final String KEY_WORD_CONSTRUCTOR_INTENT = "android.content.Intent: void <init>";
	public static final String KEY_WORD_SET_METHOD = "android.content.Intent: android.content.Intent set";
	public static final String KEY_WORD_SET_ACTION_METHOD = "android.content.Intent: android.content.Intent setAction";
	public static final String KEY_WORD_SET_CLASS_METHOD = "android.content.Intent: android.content.Intent setClass";
	public static final String KEY_WORD_SET_CLASSNAME_METHOD = "android.content.Intent: android.content.Intent setClassName";
	public static final String KEY_WORD_SET_COMPONENT = "android.content.Intent: android.content.Intent setComponent";
	public static final String KEY_WORD_LAUNCHING_INTENT1 = "void start";
	public static final String KEY_WORD_LAUNCHING_INTENT2 = "boolean start";
	public static final String KEY_WORD_LAUNCHING_INTENT3 = "android.content.ComponentName start";

	public static final String KEY_WORD_PARATEMER = "@parameter";
	public static final String KEY_WORD_IF = "if ";
	public static final String KEY_WORD_GOTO = "goto ";
	public static final String KEY_WORD_STATEMENT_RETURN = "return";
	public static final String KEY_WORD_CONSTRUCTOR = ": void <init>";

	// Constants for printing the help description from CommandLine perspective.
	public static final String HELP_OPTION_DESCRIPTION = "Tool options: Please choose any one of these options,"
			+ "Analysis ==>(ANALYZE/ANA/ANALYSIS/A)" + "," + "LOAD ==> (LOAD/L)" + ","
			+ "HELP ==> (HELP, H, -HELP, -H, MAN, -MAN).";
	public static final String HELP_LEVEL_DESCRIPTION = "Analysis Level: COMPULSORY for all the levels. Please choose any one of these options,"
			+ "Level1 ==>(1/LEVEL 1/LEVEL1/INTRA-APP-PERMISSION/INTRA-PERM/INTRA-APP-PERM)"
			+ ","
			+ "Level2a ==> (2A/LEVEL 2A/LEVEL2A/INTRA-APP-INFO-FLOW/INTRA-INFO-FLOW/INTRA-IF)"
			+ ","
			+ "Level2b ==> (2B/LEVEL 2B/LEVEL2B/INTER-APP-PERMISSION/INTER-APP-PERM/INTER-PERM)";
	public static final String HELP_LEVELMODE_DESCRIPTION = "Analysis Level Specific Mode: COMPULSORY for LEVEL2B Scenario: Please choose any one of these options,"
			+ "(APP/ALL).";
	public static final String HELP_INPUTAPK_DESCRIPTION = "Initial APK file path. COMPULSORY for all the levels.";
	public static final String HELP_NONNATIVEAPK_DESCRIPTION = "Non Native APK file path. Optional field to give for LEVEL2B scenario.";
	public static final String HELP_COMPAREINPUT_DESCRIPTION = "Previous analysis file path for 'Comparison Mode'. COMPULSORY if you want to use this mode.";
	public static final String HELP_RESULTREP_DESCRIPTION = "Result Representation Option. Available options,"
			+ "Save ==>(S/SAVE/SA)" + "," + "View ==> (V/VIEW/VI)";
	public static final String HELP_RESULTVIEW_DESCRIPTION = "Result View Option. Available options,"
			+ "Textual ==>(T/TEXT/TEXTUAL)" + "," + "Graphical ==> (G, GRAPH, GRAPHICAL)" + ","
			+ "Message ==> (M, MSG, MESSAGE)";
	public static final String HELP_SAVEORVIEWFP_DESCRIPTION = "File path for Viewing previous result/Saving current analysis result. COMPULSORY for both these scenarios";
	public static final String HELP_EXIT_DESCRIPTION = "Terminate the program after the analysis execution.";
	public static final String HELP_FILTERS_DESCRIPTION = "Provide the 'Result Filters'. Can give more than one value by giving space between them. Some filter options are:Please choose any one of these options,"
			+ "Filters ==>(REQUIRED/MAYBE_REQUIRED/UNUSED/MISSING/MAYBE_MISSING)";
	public static final String HELP_DETAILLEVEL_DESCRIPTION = "Provide the 'Detail Level'. Available options,"
			+ "DetailLevelLvl1 ==>(APP/COMPONENT/CLASS/METHOD)" + ","
			+ "DetailLevelLvl2a ==> (RES_TO_RES/COMPONENT/STATEMENT)" + "," + "DetailLevelLvl2b ==> (APP/COMPONENT)";
	public static final String HELP_TESTSCENARIO_DESCRIPTION = "Whether you want the testing scenario to be enabled?"
			+ "If so use this option so that result won't be printed in the console.";
	public static final String HELP_TESTSTATS_DESCRIPTION = "Showing test statistics in the result.";

	public static final String SAVE_RESULT_SUCCESS = "Successfully saved the result.";
	public static final String SAVE_RESULT_FAILURE = "Failed to save the result.";
	public static final String DESERIALIZED_MESSAGE = "Deserialized AnalysisResult...";
	public static final String RESULT_CLASS_NOT_FOUND = "AnalysisResult class not found";
	public static final String FILE_CONVERTER_MESSAGE = "A file with apk extension was not provided. Unsupported input file format.";

	private static String[] activityMethods = { ACTIVITY_ONCREATE, ACTIVITY_ONDESTROY, ACTIVITY_ONPAUSE,
			ACTIVITY_ONRESTART, ACTIVITY_ONRESUME, ACTIVITY_ONSTART, ACTIVITY_ONSTOP, ACTIVITY_ONSAVEINSTANCESTATE,
			ACTIVITY_ONRESTOREINSTANCESTATE, ACTIVITY_ONCREATEDESCRIPTION, ACTIVITY_ONPOSTCREATE, ACTIVITY_ONPOSTRESUME };

	private static String[] serviceMethods = { SERVICE_ONCREATE, SERVICE_ONDESTROY, SERVICE_ONSTART1, SERVICE_ONSTART2,
			SERVICE_ONBIND, SERVICE_ONREBIND, SERVICE_ONUNBIND };

	private static String[] broadcastMethods = { BROADCAST_ONRECEIVE };

	private static String[] contentproviderMethods = { CONTENTPROVIDER_ONCREATE };

	private static String[] constructorIntentStatements = { METHOD_CONSTRUCTOR_INTENT1, METHOD_CONSTRUCTOR_INTENT2,
			METHOD_CONSTRUCTOR_INTENT3, METHOD_CONSTRUCTOR_INTENT4, METHOD_CONSTRUCTOR_INTENT5,
			METHOD_CONSTRUCTOR_INTENT6 };

	public static List<String> getConstructorIntentStatements() {
		return Arrays.asList(constructorIntentStatements);
	}

	public static List<String> getActivityLifecycleMethods() {
		return Arrays.asList(activityMethods);
	}

	public static List<String> getServiceLifecycleMethods() {
		return Arrays.asList(serviceMethods);
	}

	public static List<String> getBroadcastLifecycleMethods() {
		return Arrays.asList(broadcastMethods);
	}

	public static List<String> getContentproviderLifecycleMethods() {
		return Arrays.asList(contentproviderMethods);
	}

	public static List<String> getGCMIntentServiceMethods() {
		return Arrays.asList(gcmIntentServiceMethods);
	}

	public static List<String> getGCMListenerServiceMethods() {
		return Arrays.asList(gcmListenerServiceMethods);
	}

}
