/**
 *
 */
package de.upb.pga3.panda2.main;

import javafx.application.Application;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.client.cmdline.CommandLine;
import de.upb.pga3.panda2.client.gui.GUIView;

/**
 *
 * Main Class for starting the application using the CommandLine and GUI.
 *
 * @author Sriram
 *
 */
public class ApplicationEntryPoint {

	static final Logger LOGGER = LogManager.getLogger(ApplicationEntryPoint.class);

	/*
	 * Variable representing instance of the CommandLine Class for the Command
	 * line scenario.
	 */
	private static CommandLine commandLine;

	/**
	 * @return the commandLine
	 */
	public static CommandLine getCommandLine() {
		return commandLine;
	}

	/**
	 * Main method for starting the CommandLine or GUI of our application based
	 * on the length of the arguments.
	 *
	 * @param args
	 *            The String[] passed as arguments while calling this entry
	 *            point method.
	 */
	public static void main(final String... args) {

		/*
		 * Initial Code Implementation for Command Line Scenario. If the
		 * args.length is greater than zero, then command line client will be
		 * called. Else, GUI will be triggered.
		 */
		if (args.length > 0) {
			commandLine = new CommandLine();
			if (commandLine.validateInitialInput(args)) {
				commandLine.saveOrShowResult();
				// Client.print("Program is terminated.");
				LOGGER.info("Program is terminated.");
				if (!commandLine.getClientCommandLine().getUserInput().isTestingScenario()) {
					System.exit(0);
				}
			}
		} else {
			Application.launch(GUIView.class);
		}
	}
}
