package de.upb.pga3.panda2.extension.lvl2b.graphgenerator;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import soot.SootClass;
import soot.Unit;

/**
 * This class is used in order to connect implicit intents with their targets.
 *
 * @author Felix
 *
 */
public class NodeLinkerLvl2b {
	private AnalysisGraph resultGraph;
	private ResultInput ri;

	/**
	 * Constructor that initializes the result graph object.
	 *
	 * @param ri
	 *            Current ResultInput object
	 */
	public NodeLinkerLvl2b(final AnalysisGraph ag) {
		this.resultGraph = ag;
		this.ri = (ResultInput) ag.getInput();
	}

	/**
	 * Links a Statement (implicit intent) to its Target by adding a
	 * {@link Transition}.
	 *
	 * @param stm
	 *            The statement that is going to be linked.
	 *
	 * @author Felix
	 */
	public void link(final IntentInformation intentInfo) {
		final List<Unit> stms = intentInfo.getLstLaunchingUnits();
		if (stms != null && !stms.isEmpty()) {
			for (final Unit stm : stms) {
				boolean enhancedInputFound = false;
				EnhancedInput ei = null;
				for (int i = 0; i < this.ri.getResults().size(); i++) {
					ei = (EnhancedInput) ((AnalysisResultLvl1) this.ri.getResults().get(i)).getAnalysisGraph()
							.getInput();
					if (ei.getBodyForUnit(stm) != null) {
						enhancedInputFound = true;
						break;
					}
				}
				if (enhancedInputFound) {
					if (intentInfo.getTargetClasses() == null) {
						this.resultGraph.addMessage(new Message(MessageType.WARNING, "Implicit intent",
								"Target could not be found in any Application."));
						return;
					} else {
						for (final SootClass target : intentInfo.getTargetClasses()) {
							if (target == null) {
								this.resultGraph.addMessage(new Message(MessageType.WARNING, "Implicit intent",
										"Target could not be found in any Application."));
								return;
							} else {
								Transition transition;
								transition = new Transition(stm, target);
								this.resultGraph.addTransition(transition);
								transition = new Transition(ei.getBodyForUnit(stm).getMethod(), target);
								this.resultGraph.addTransition(transition);
								transition = new Transition(ei.getBodyForUnit(stm).getMethod().getDeclaringClass(),
										target);
								this.resultGraph.addTransition(transition);
							}
						}
					}
				} else {
					throw new NullPointerException("Could not find implicit intent source.");
				}
			}
		}
	}

	public AnalysisGraph getGraph() {
		return this.resultGraph;
	}

}
