package de.upb.pga3.panda2.extension.lvl2b;

/**
 * Objects of this type represent one part of the Permission-Group bar in the
 * graphical result.
 *
 * @author Felix
 */
public class SVGBarLvl2b {
	private int x;
	private int y;
	private int height;

	SVGBarLvl2b(final int x, final int y, final int height) {
		this.x = x;
		this.y = y;
		this.height = height;
	}

	public int getX() {
		return this.x;
	}

	public int getY() {
		return this.y;
	}

	public int getHeight() {
		return this.height;
	}

	public int getClosestTo(final int yPermission) {
		if (this.height <= 20) {
			return this.y + Math.round(this.height / 2f);
		} else if (yPermission <= this.y + 10) {
			return this.y + 10;
		} else if (yPermission >= (this.y + this.height - 10)) {
			return this.y + this.height - 10;
		} else {
			return yPermission;
		}
	}
}
