package de.upb.pga3.panda2.extension.lvl2b;

/**
 * This class is used to structure the all parts of the level 2b analysis
 * result.
 *
 * @author Felix
 *
 */
public class ResultTypeLvl2b {
	/**
	 * Permission-Groups available
	 */
	public static final int NOT_AVAILABLE = -1;
	public static final int REQUIRED = 0;
	public static final int MAYBE_REQUIRED = 1;
	public static final int UNUSED = 2;
	public static final int MISSING = 3;
	public static final int MAYBE_MISSING = 4;
	public static final int ALL = 5;

	/**
	 * Return the color for this type of permission.
	 *
	 * @param type
	 *            Defines which type of permission
	 * @return The hex color value for use in HTML
	 */
	public static String getColorOfType(final int type) {
		switch (type) {
		case NOT_AVAILABLE:
			return "#777777";
		case REQUIRED:
			return "#007f22";
		case MAYBE_REQUIRED:
			return "#0006fd";
		case UNUSED:
			return "#927a3a";
		case MISSING:
			return "#ff0000";
		case MAYBE_MISSING:
			return "#ff7500";
		default:
			return "#000000";
		}
	}

	/**
	 * Computes the headlines for parts of the analysis results.
	 *
	 * @param type
	 *            Defines which headline shall be computed
	 * @return The headline belonging to the selected type
	 */
	public static String getStringOfType(final int type) {
		switch (type) {
		case NOT_AVAILABLE:
			return "NOT AVAILABLE";
		case REQUIRED:
			return "REQUIRED";
		case MAYBE_REQUIRED:
			return "MAYBE REQUIRED";
		case UNUSED:
			return "UNUSED";
		case MISSING:
			return "MISSING";
		case MAYBE_MISSING:
			return "MAYBE MISSING";
		default:
			return "UNKNOWN";
		}
	}

	/**
	 * Returns the type according to the headline.
	 *
	 * @param str
	 *            Headline
	 * @return The type mapped to the input headline
	 */
	public static int getTypeByString(final String str) {
		switch (str) {
		case "NOT AVAILABLE":
			return NOT_AVAILABLE;
		case "REQUIRED":
			return REQUIRED;
		case "MAYBE REQUIRED":
			return MAYBE_REQUIRED;
		case "UNUSED":
			return UNUSED;
		case "MISSING":
			return MISSING;
		case "MAYBE MISSING":
			return MAYBE_MISSING;
		default:
			return -1;
		}
	}
}
