package de.upb.pga3.panda2.extension.lvl2b;

import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.core.datastructures.Permission;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

/**
 * This class is used to created leafes for any {@link ResultTreeLvl2b}.
 *
 * @author Felix
 *
 */
public class ResultLeafLvl2b {
	// Data stored in a leaf
	private String inName;
	private TIntObjectMap<List<ResultItemLvl2b>> inResultItems;

	/**
	 * Constructor creating a new leaf
	 *
	 * @param inName
	 *            the name of the element, which belongs to this leaf.
	 */
	public ResultLeafLvl2b(final String inName) {
		this.inName = inName;
		this.inResultItems = new TIntObjectHashMap<>();
		for (int i = 0; i < 5; i++) {
			this.inResultItems.put(i, new ArrayList<ResultItemLvl2b>());
		}
	}

	/**
	 * The name of the element referenced by this leaf.
	 *
	 * @return the elements name (E.g. the jimple representation of a class).
	 */
	public String getName() {
		return this.inName;
	}

	/**
	 * Returns all {@link ResultItemLvl2b}s assigned to this leaf.
	 *
	 * @param type
	 *            Permission-Group of the returned {@link ResultItemLvl2b}s.
	 * @return List of {@link ResultItemLvl2b}s
	 */
	public List<ResultItemLvl2b> getResultItems(final int type) {
		if (type == ResultTypeLvl2b.ALL) {
			final List<ResultItemLvl2b> all = new ArrayList<>();
			for (int i = 0; i < 5; i++) {
				all.addAll(getResultItems(i));
			}
			return all;
		} else {
			return this.inResultItems.get(type);
		}
	}

	/**
	 * Adds a {@link Permission} to this leaf
	 *
	 * @param permission
	 *            Permission to be added.
	 * @param type
	 *            Definition of the Permission-Group the permission defined in
	 *            the first parameter belongs to.
	 * @param direct
	 *            This stands for the type of access to the permission. Whether
	 *            it is direct or indirect.
	 */
	public void addPermission(final Permission permission, final int type, final int direct) {
		for (final ResultItemLvl2b resultItem : this.inResultItems.get(type)) {
			if (resultItem.getPermission().equals(permission)) {
				return;
			}
		}
		this.inResultItems.get(type).add(new ResultItemLvl2b(permission, direct));
	}
}
