/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.Chain;

/**
 * NodeLinkTransformerPart2 extends BodyTransformer
 *
 * @author nptsy
 * @author RamKumar
 */
public class NodeLinkTransformerPart2 extends BodyTransformer {

	// Mapping of Method Names and associated unit graphs.
	private HashMap<SootMethod, UnitGraph> methodUnitGraphMap = new HashMap<>();

	// Mapping of Methods, local variables and Statements associated with the
	// locals.
	// private Map<SootMethod, Map<Local, Unit>> methodLocDefStmtMap = new
	// HashMap<>();
	private Map<SootMethod, Map<Unit, List<Unit>>> useStmtDefStmtMap = new HashMap<>();
	private Map<SootMethod, List<Unit>> methodInvkStmtMap = new HashMap<>();

	private Map<SootMethod, List<Value>> methodParamMap = new HashMap<>();
	private Map<SootMethod, Map<Value, Unit>> methodParamIdntUnitMap = new HashMap<>();
	private Map<SootMethod, Unit> methodRetnStmtMap = new HashMap<>();

	/*
	 * (non-Javadoc)
	 *
	 * @see soot.BodyTransformer#internalTransform(soot.Body, java.lang.String,
	 * java.util.Map)
	 */
	@Override
	protected void internalTransform(final Body body, final String arg1, final Map<String, String> option) {

		// put unit graph in to the map with key is the signature of the method
		final UnitGraph ugraph = new ExceptionalUnitGraph(body);

		// using SmartlocalDef
		final SmartLocalDefs smd = new SmartLocalDefs(ugraph, new SimpleLiveLocals(ugraph));

		this.methodUnitGraphMap.put(body.getMethod(), ugraph);

		// SootMethod associated with this Body
		final SootMethod smethod = body.getMethod();

		// Get the List of Parameter Locals for the SootMethod associated with
		// this Body
		final List<Local> paramListLocal = body.getParameterLocals();
		final List<Value> paramListValue = new ArrayList<Value>();

		// Type Convert List<Local> to List<Value> and to the maps.
		if (!paramListLocal.isEmpty()) {
			for (final Local l : paramListLocal) {
				paramListValue.add(l);
			}
			this.methodParamMap.put(smethod, paramListValue);
			this.methodParamIdntUnitMap.put(smethod, new HashMap<Value, Unit>());
		}

		// Initialise the Maps with SootMethod as the key.

		// this.methodLocDefStmtMap.put(sm, new HashMap<Local, Unit>());
		this.useStmtDefStmtMap.put(smethod, new HashMap<Unit, List<Unit>>());
		this.methodInvkStmtMap.put(smethod, new ArrayList<Unit>());

		// Iterate through each Unit in the Body to Identify Unit which define
		// a local and Unit that use the definition

		final Chain<Unit> unit = body.getUnits();

		final Iterator unitIt = unit.iterator();
		while (unitIt.hasNext()) {
			final Unit unt = (Unit) unitIt.next();

			// Obtain the Use Boxes in the Unit and Look up for the definition
			// in the above Map. Create a new Map of Unit that uses some Locals
			// and the associated Definition Units

			this.useStmtDefStmtMap.get(smethod).put(unt, new ArrayList<Unit>());
			final List<ValueBox> vbList = unt.getUseBoxes();

			for (final ValueBox vb : vbList) {
				if (vb.getValue() instanceof Local) {
					final Local loc = (Local) vb.getValue();
					final List<Unit> defUnits = smd.getDefsOfAt(loc, unt);
					if (defUnits != null && !defUnits.isEmpty()) {
						for (final Unit defUnit : defUnits) {
							this.useStmtDefStmtMap.get(smethod).get(unt).add(defUnit);
						}
					}
				}
			}

			// If the Unit is an Invoke Statement, create a new Mapping
			final Stmt stmnt = (Stmt) unt;
			if (stmnt.containsInvokeExpr()) {
				this.methodInvkStmtMap.get(smethod).add(unt);
			}

			// If the Unit is a Return statement, create a new Mapping
			if (stmnt instanceof ReturnStmt) {
				this.methodRetnStmtMap.put(smethod, unt);
			}

			// If the Unit is an Identity Statment, create a Mapping of
			// Parameter Local variable and associated Identity Unit
			if (stmnt instanceof IdentityStmt) {
				final Value val = ((IdentityStmt) stmnt).getLeftOp();
				if (paramListValue.contains(val)) {
					this.methodParamIdntUnitMap.get(smethod).put(val, unt);
				}
			}
		}

	}

	/**
	 *
	 * @return map of Soot Methods and their unit graph
	 */
	public HashMap<SootMethod, UnitGraph> getMap() {
		return this.methodUnitGraphMap;
	}

	/**
	 * Method to return method-local-use-statements Map
	 *
	 *
	 * @return method-local-use-statements Map
	 */

	public Map<SootMethod, Map<Unit, List<Unit>>> getUseStmtDefStmtMap() {
		return this.useStmtDefStmtMap;
	}

	/**
	 *
	 * @return Map of methods and list of invoke units in the method
	 */
	public Map<SootMethod, List<Unit>> getMethodInvkExprMap() {
		return this.methodInvkStmtMap;
	}

	/**
	 *
	 * @return Map of methods and their parameters
	 */
	public Map<SootMethod, List<Value>> getMethodParamMap() {

		return this.methodParamMap;
	}

	/**
	 *
	 * @return Map of methods and return statement in each method
	 */
	public Map<SootMethod, Unit> getMethodRetnStmtMap() {
		return this.methodRetnStmtMap;
	}

	/**
	 *
	 * @return Map of method and identity stmnt that initialise parameter
	 *         variables of the method
	 */
	public Map<SootMethod, Map<Value, Unit>> getMethodParamIdentityUnitMap() {
		return this.methodParamIdntUnitMap;
	}
}
