/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import java.nio.file.Path;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.extension.GraphGenerator;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;

/**
 * GraphGenerator class
 *
 * @author nptsy
 * @author Monika
 */
public class GraphGeneratorLvl2a implements GraphGenerator {

	private IntentAnalyzerLvl2a mIntentAnalyzerLvl2a;
	private NodeLinkerLvl2a mNodeLinkerLvl2a;

	private static final Logger LOGGER = LogManager.getLogger(GraphGeneratorLvl2a.class);

	/**
	 * Constructor
	 */
	public GraphGeneratorLvl2a() {
		this.mNodeLinkerLvl2a = new NodeLinkerLvl2a();
		this.mIntentAnalyzerLvl2a = new IntentAnalyzerLvl2a(this.mNodeLinkerLvl2a);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * de.upb.pga3.panda2.extension.GraphGenerator#generateGraph(de.upb.pga3
	 * .panda2.core.datastructures.Input, java.nio.file.Path)
	 */
	@Override
	public AnalysisGraph generateGraph(final Input input, final Path apk) {
		LOGGER.info("GraphGenerator started (Source&Sink - Intra App - Level 2a).");

		final AnalysisGraphLvl2a graph = createAnalysisGraphFromInput(input);

		LOGGER.info("GraphGenerator finished (Source&Sink - Intra App - Level 2a).");
		return graph;
	}

	/**
	 * create analysis graph for level 2a
	 *
	 * @param inInput
	 *            input for create graph
	 * @return AnalysisGraphLvl2a object for level 2a
	 */
	private AnalysisGraphLvl2a createAnalysisGraphFromInput(final Input inInput) {
		AnalysisGraphLvl2a graph = new AnalysisGraphLvl2a(inInput);
		graph = enrichGraph(graph);
		return graph;
	}

	/**
	 * enrich graph with information about intents and with data flow
	 *
	 * @param inGraph
	 *            analysisGraph of level 2a
	 * @return an enriched AnalysisGraphLvl2a object with information of intents
	 *         for lvl2a
	 */
	private AnalysisGraphLvl2a enrichGraph(final AnalysisGraphLvl2a inGraph) {
		AnalysisGraphLvl2a graph = this.mNodeLinkerLvl2a.link(inGraph);
		// process for explicit intents
		graph = this.mIntentAnalyzerLvl2a.analyzeExplicitIntents(graph);
		// process for implicit intents
		graph = this.mIntentAnalyzerLvl2a.analyzeImplicitIntents(graph);
		return graph;
	}

}
