/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;

/**
 * This Class implements the algorithm to compute a dominator tree from: A Fast
 * Algorithm for Finding Dominators in a Flowgraph, by Lengauer, Tarjan
 *
 * @author Monika
 *
 */

public class DominatorComputer {

	int[] parent;
	private int[] ancestor;
	private int[] vertex;
	private int[] label;
	int[] semi;
	TIntSet[] pred;
	private TIntSet[] bucket;
	int u;

	private TIntSet[] succ;
	private int r, n;
	private int[] dom;

	/**
	 * computes the dominator tree for a given control flow graph
	 *
	 * @param inSucc
	 *            the array representing the control flow graph
	 * @param inR
	 *            the node representing the root of the control flow graph
	 * @param inN
	 *            the number of nodes in the control flow graph
	 * @return the dominator tree for the given control flow graph
	 */
	public int[] computeDominatorTree(final TIntSet[] inSucc, final int inR, final int inN) {
		this.succ = inSucc;
		this.r = inR;
		this.n = inN;

		this.vertex = new int[this.n];
		this.parent = new int[this.n];
		this.ancestor = new int[this.n];

		this.semi = new int[this.n];
		this.label = new int[this.n];

		this.pred = new TIntHashSet[this.n];
		this.bucket = new TIntHashSet[this.n];
		this.dom = new int[this.n];

		for (int v = 1; v < this.n; v++) {
			this.bucket[v] = new TIntHashSet();
			this.pred[v] = new TIntHashSet();
			this.semi[v] = 0;
		}
		this.n = 0;
		dfs(this.r);
		for (int i = this.n; i >= 2; i--) {
			final int w = this.vertex[i];
			this.pred[w].forEach(new TIntProcedure() {

				@Override
				public boolean execute(final int v) {
					DominatorComputer.this.u = eval(v);
					if (DominatorComputer.this.semi[DominatorComputer.this.u] < DominatorComputer.this.semi[w]) {
						DominatorComputer.this.semi[w] = DominatorComputer.this.semi[DominatorComputer.this.u];
					}
					return true;
				}
			});
			this.bucket[this.vertex[this.semi[w]]].add(w);
			link(this.parent[w], w);
			final TIntIterator iter = this.bucket[this.parent[w]].iterator();
			while (iter.hasNext()) {
				final int v = iter.next();
				iter.remove();
				this.u = eval(v);
				if (this.semi[this.u] < this.semi[v]) {
					this.dom[v] = this.u;
				} else {
					this.dom[v] = this.parent[w];
				}
			}
		}
		for (int i = 2; i < this.n; i++) {
			final int w = this.vertex[i];
			if (this.dom[w] != this.vertex[this.semi[w]]) {
				this.dom[w] = this.dom[this.dom[w]];
			}
		}
		this.dom[this.r] = 0;
		return this.dom;
	}

	private void dfs(final int v) {
		this.semi[v] = this.n + 1;
		this.n++;
		if (this.n < this.vertex.length) {
			this.vertex[this.n] = v;
			this.label[v] = v;
			this.ancestor[v] = 0;
			this.succ[v].forEach(new TIntProcedure() {

				@Override
				public boolean execute(final int w) {
					if (DominatorComputer.this.semi[w] == 0) {
						DominatorComputer.this.parent[w] = v;
						dfs(w);
					}
					if (DominatorComputer.this.pred[w] == null) {
						DominatorComputer.this.pred[w] = new TIntHashSet();
					}
					DominatorComputer.this.pred[w].add(v);
					return true;
				}
			});
		}
	}

	private void compress(final int v) {
		if (this.ancestor[this.ancestor[v]] != 0) {
			compress(this.ancestor[v]);
			if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
				this.label[v] = this.label[this.ancestor[v]];
			}
			this.ancestor[v] = this.ancestor[this.ancestor[v]];
		}
	}

	private int eval(final int v) {
		if (this.ancestor[v] == 0) {
			return v;
		} else {
			compress(v);
			return this.label[v];
		}
	}

	private void link(final int a, final int w) {
		this.ancestor[w] = a;

	}
}
