package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import java.util.HashMap;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import soot.Unit;

public final class StatementElement implements PathElement {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 3182548952315866563L;

	private static final Map<StatementElement, StatementElement> instancePool = new HashMap<>();

	private final String statementStr;
	private final MethodElement method;

	public static StatementElement get(final Unit statement, final EnhancedInput input) {

		StatementElement stmntEle = new StatementElement(statement, input);
		if (instancePool.containsKey(stmntEle)) {
			stmntEle = instancePool.get(stmntEle);
		} else {
			instancePool.put(stmntEle, stmntEle);
		}
		return stmntEle;
	}

	private StatementElement(final Unit statement, final EnhancedInput input) {

		if (statement == null) {
			throw new IllegalArgumentException("The given statement must not be null!");
		}
		if (input == null) {
			throw new IllegalArgumentException("The given enhanced input must not be null!");
		}

		this.statementStr = statement.toString();
		this.method = MethodElement.get(input.getBodyForUnit(statement).getMethod(), input);
	}

	public String getStatementString() {
		return toString();
	}

	public MethodElement getMethodElement() {
		return this.method;
	}

	@Override
	public String toFullString() {
		return this.method.toFullString() + "\n" + toString();
	}

	@Override
	public String toString() {
		return this.statementStr;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.method == null) ? 0 : this.method.hashCode());
		result = prime * result + ((this.statementStr == null) ? 0 : this.statementStr.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final StatementElement other = (StatementElement) obj;
		if (this.method == null) {
			if (other.method != null) {
				return false;
			}
		} else if (!this.method.equals(other.method)) {
			return false;
		}
		if (this.statementStr == null) {
			if (other.statementStr != null) {
				return false;
			}
		} else if (!this.statementStr.equals(other.statementStr)) {
			return false;
		}
		return true;
	}

}
