package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import java.util.HashMap;
import java.util.Map;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import soot.SootClass;

public final class ClassElement implements PathElement {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -1847806292089463348L;

	private static final Map<ClassElement, ClassElement> instancePool = new HashMap<>();

	private final String className;
	private final boolean isAndroidComponent;

	public static ClassElement get(final SootClass clazz, final EnhancedInput input) {

		ClassElement classEle = new ClassElement(clazz, input);
		if (instancePool.containsKey(classEle)) {
			classEle = instancePool.get(classEle);
		} else {
			instancePool.put(classEle, classEle);
		}
		return classEle;
	}

	private ClassElement(final SootClass clazz, final EnhancedInput input) {

		if (clazz == null) {
			throw new IllegalArgumentException("The given class must not be null!");
		}
		if (input == null) {
			throw new IllegalArgumentException("The given enhanced input must not be null!");
		}

		this.className = clazz.getName();
		this.isAndroidComponent = input.isAndroidComponent(clazz);
	}

	public String getClassName() {
		return toString();
	}

	public boolean isAndroidComponent() {
		return this.isAndroidComponent;
	}

	@Override
	public String toFullString() {
		return toString();
	}

	@Override
	public String toString() {
		return this.className;
	}

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.className == null) ? 0 : this.className.hashCode());
		result = prime * result + (this.isAndroidComponent ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(final Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final ClassElement other = (ClassElement) obj;
		if (this.className == null) {
			if (other.className != null) {
				return false;
			}
		} else if (!this.className.equals(other.className)) {
			return false;
		}
		if (this.isAndroidComponent != other.isAndroidComponent) {
			return false;
		}
		return true;
	}

}