/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Transition;
import soot.EquivTo;
import soot.SootMethod;
import soot.Unit;

/**
 * Transition for graph Lvl2a
 *
 * @author nptsy
 * @author Fabian
 */
public class TransitionLvl2a extends Transition implements EquivTo {

	private final TransitionType mTransitionType;

	/**
	 * Creates a Transition between a source and a target node of unspecified
	 * type
	 *
	 * @param inEleFrom
	 *            source element
	 * @param inEleTo
	 *            sink or target element
	 */
	public TransitionLvl2a(final Object inEleFrom, final Object inEleTo) {
		this(inEleFrom, inEleTo, TransitionType.UNSPECIFIED);
	}

	/**
	 * Creates a Transition between a source and a target node of given type
	 *
	 * @param inEleFrom
	 *            The source node
	 * @param inEleTo
	 *            The target node
	 * @param inType
	 *            The type of the Transition
	 */
	public TransitionLvl2a(final Object inEleFrom, final Object inEleTo, final TransitionType inType) {

		super(inEleFrom, inEleTo);
		this.mTransitionType = inType;
	}

	/**
	 * Creates a Transition from a given one with given type
	 *
	 * @param inTrans
	 *            The original Transition
	 * @param inType
	 *            The type of the Transition
	 */
	public TransitionLvl2a(final Transition inTrans, final TransitionType inType) {
		this(inTrans.getSource(), inTrans.getTarget(), inType);
	}

	/**
	 * Creates a Transition from a given one with unspecified type
	 *
	 * @param inTrans
	 *            The original Transition
	 */
	public TransitionLvl2a(final Transition inTrans) {
		this(inTrans.getSource(), inTrans.getTarget());
	}

	/**
	 * get transition type
	 *
	 * @return TransitionType object
	 */
	public TransitionType getTransitionType() {
		return this.mTransitionType;
	}

	@Override
	public int equivHashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.mTransitionType == null) ? 0 : this.mTransitionType.hashCode());
		result = prime * result + ((this.mEleFrom == null) ? 0 : this.mEleFrom.toString().hashCode());
		result = prime * result + ((this.mEleTo == null) ? 0 : this.mEleTo.toString().hashCode());
		return result;
	}

	@Override
	public boolean equivTo(final Object obj) {
		return equivTo(obj, null, null);
	}

	public boolean equivTo(final Object obj, final EnhancedInput inp, final EnhancedInput otherInp) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final TransitionLvl2a other = (TransitionLvl2a) obj;
		if (this.mTransitionType != other.mTransitionType) {
			return false;
		}
		if (this.mEleFrom == null) {
			if (other.mEleFrom != null) {
				return false;
			}
		} else if (!equivToFullName(this.mEleFrom, other.mEleFrom, inp, otherInp)) {
			return false;
		}
		if (this.mEleTo == null) {
			if (other.mEleTo != null) {
				return false;
			}
		} else if (!equivToFullName(this.mEleTo, other.mEleTo, inp, otherInp)) {
			return false;
		}
		return true;
	}

	private static boolean equivToFullName(final Object thisEle, final Object otherEle, final EnhancedInput inp,
			final EnhancedInput otherInp) {

		if (thisEle == otherEle) {
			return true;
		}
		if (thisEle == null) {
			if (otherEle != null) {
				return false;
			}
		} else if (!thisEle.toString().equals(otherEle.toString())) {
			return false;
		}
		if (thisEle instanceof SootMethod && otherEle instanceof SootMethod) {
			return equivToFullName(((SootMethod) thisEle).getDeclaringClass(),
					((SootMethod) otherEle).getDeclaringClass(), inp, otherInp);
		}
		if (thisEle instanceof Unit && otherEle instanceof Unit && inp != null && otherInp != null) {
			return equivToFullName(inp.getBodyForUnit((Unit) thisEle).getMethod(),
					otherInp.getBodyForUnit((Unit) otherEle).getMethod(), inp, otherInp);
		}
		// if (thisEle.getClass() != otherEle.getClass()) {
		// return false;
		// }
		return true;
	}
}
