/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a;

import soot.SootMethod;
import soot.Unit;
import soot.Value;

/**
 * Parameter
 *
 * @author nptsy
 * @author Fabian
 */
public class ParameterNode {

	private final Value mParamValue;
	private final Unit mInvokeStmnt;
	private final SootMethod mMethod;
	private final ParamType mType;
	private final int mIndex;

	/**
	 * Constructor
	 *
	 * @param inName
	 *            The name of the parameter
	 * @param inInvokeStmnt
	 *            The Unit the parameter was used in to invoke a method
	 */
	public ParameterNode(final Value inParamValue, final ParamType inType, final Unit inInvokeStmnt,
			final int inIndex) {
		this.mParamValue = inParamValue;
		this.mInvokeStmnt = inInvokeStmnt;
		this.mType = inType;
		this.mMethod = null;
		this.mIndex = inIndex;
	}

	/**
	 * Constructor
	 *
	 * @param inName
	 *            The name of the parameter
	 */
	public ParameterNode(final Value inParamValue, final ParamType inType, final SootMethod inMethod,
			final int inIndex) {
		this.mParamValue = inParamValue;
		this.mMethod = inMethod;
		this.mType = inType;
		this.mInvokeStmnt = null;
		this.mIndex = inIndex;
	}

	/**
	 * Gives the name of the parameter
	 *
	 * @return The name of the parameter
	 */
	public Value getParameterValue() {
		return this.mParamValue;
	}

	/**
	 * Gives the index of the parameter
	 *
	 * @return the mIndex
	 */
	public int getIndex() {
		return this.mIndex;
	}

	/**
	 * Gives the type of the parameter node
	 *
	 * @return The type of the node
	 */
	public ParamType getType() {
		return this.mType;
	}

	/**
	 * Gives the Unit the parameter was used in to invoke a method
	 *
	 * @return The Unit used in
	 */
	public Unit getCorrespondingUnit() {
		return this.mInvokeStmnt;
	}

	/**
	 * Gives the Method the parameter is used for
	 *
	 * @return The Method
	 */
	public SootMethod getCorrespondingMethod() {
		return this.mMethod;
	}

	/**
	 * check if a method of current parameter is null or not
	 *
	 * @return true if not null, otherwise false
	 */
	public boolean belongsToMethod() {
		return this.mMethod != null;
	}

	/**
	 * check if a statement
	 *
	 * @return
	 */
	public boolean belongsToUnit() {
		return this.mInvokeStmnt != null;
	}
}
