/**
 *
 */
package de.upb.pga3.panda2.extension.lvl2a;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.AnalysisProcedure;
import de.upb.pga3.panda2.extension.A3AnalysisProcedure;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.AnalyzerLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.GraphGeneratorLvl2a;

/**
 * AnalysisFactoryLvl2a class
 *
 * @author nptsy
 * @author Monika
 */
public class AnalysisFactoryLvl2a implements AnalysisFactory {

	private Path apk;
	private AnalysisResultLvl2a prevRes;
	private Path apkForPrevRes;

	/**
	 * Constructor for the Level 2a Factory
	 *
	 * @param apk
	 *            the path to the apk to be analyzed
	 * @param prevRes
	 *            a previous analysis result for comparison mode or null for
	 *            summary mode
	 */
	public AnalysisFactoryLvl2a(final Path apk, final AnalysisResultLvl2a prevRes) {
		this.apk = apk;
		this.prevRes = prevRes;
		this.apkForPrevRes = null;
	}

	/**
	 * @param inPathNewAPK
	 *            the path to the apk to be analyzed
	 * @param inPathOldAPK
	 *            the path to a second apk for comparison mode or null for
	 *            summary mode
	 */
	public AnalysisFactoryLvl2a(final Path inPathNewAPK, final Path inPathOldAPK) {
		this.apk = inPathNewAPK;
		this.prevRes = null;
		this.apkForPrevRes = inPathOldAPK;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.upb.pga3.panda2.core.AnalysisFactory#createAnalysis()
	 */
	@Override
	public List<Analysis> createAnalysis() {

		// Create Analysis
		final AnalysisProcedure anaProc = new A3AnalysisProcedure(new GraphGeneratorLvl2a(), new AnalyzerLvl2a());
		final Analysis ana = new Analysis(this.apk, this.prevRes, anaProc);

		// Create and fill list
		final List<Analysis> analysesList = new ArrayList<>();
		if (this.apkForPrevRes != null) {
			// Create comparison Analysis
			final AnalysisProcedure anaProcComp = new A3AnalysisProcedure(new GraphGeneratorLvl2a(),
					new AnalyzerLvl2a());
			final Analysis anaComp = new Analysis(this.apkForPrevRes, null, anaProcComp);
			analysesList.add(anaComp);
		}
		analysesList.add(ana);

		return analysesList;
	}
}
