package de.upb.pga3.panda2.extension.lvl1.graphgenerator;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.IntentInformation;
import soot.SootClass;
import soot.Unit;

/**
 * This class is used in order to connect explicit intents with their targets.
 *
 * @author Felix
 */
public class NodeLinkerLvl1 {
	private AnalysisGraph resultGraph;
	private EnhancedInput ei;

	/**
	 * Constructor that initializes the result graph object.
	 *
	 * @param ag
	 *            Current AnalysisGraph object
	 */
	public NodeLinkerLvl1(final AnalysisGraph ag) {
		this.resultGraph = ag;
		this.ei = (EnhancedInput) ag.getInput();
	}

	/**
	 * Links a Statement (explicit intent) to its Target by adding a
	 * {@link Transition}.
	 *
	 * @param stm
	 *            The statement that is going to be linked.
	 */
	public void link(final IntentInformation intentInfo) {
		if (intentInfo.getTargetClasses() == null || intentInfo.getTargetClasses().isEmpty()) {
			this.resultGraph.addMessage(new Message(MessageType.INFO, "No Target",
					"No target class could not be found for explicit intent definition"));
			return;
		}
		final List<Unit> stms = intentInfo.getLstLaunchingUnits();
		if (stms != null && !stms.isEmpty()) {
			for (final Unit stm : stms) {
				for (final SootClass target : intentInfo.getTargetClasses()) {
					Transition transition;
					transition = new Transition(stm, target);
					this.resultGraph.addTransition(transition);
					transition = new Transition(this.ei.getBodyForUnit(stm).getMethod(), target);
					this.resultGraph.addTransition(transition);
					transition = new Transition(this.ei.getBodyForUnit(stm).getMethod().getDeclaringClass(), target);
					this.resultGraph.addTransition(transition);
				}
			}
		}
	}

	public AnalysisGraph getGraph() {
		return this.resultGraph;
	}
}
