package de.upb.pga3.panda2.extension.lvl1.graphgenerator;

import java.util.Collection;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;

/**
 * This class is using the {@link StatementAnalyzer} in order to link the
 * {@link EnhancedInput} accordingly.
 *
 * @author Felix
 */
public class IntentAnalyzerLvl1 {

	private EnhancedInput ei;
	private NodeLinkerLvl1 nodeLinker;
	private AnalysisGraph resultGraph;

	/**
	 * Constructor is initializing the Nodelinker
	 *
	 * @param ei
	 *            EnhancedInput object generated so far
	 */
	public IntentAnalyzerLvl1(final EnhancedInput ei) {
		this.ei = ei;
		this.resultGraph = new AnalysisGraph(ei);
		this.nodeLinker = new NodeLinkerLvl1(this.resultGraph);
	}

	/**
	 * Iterates over all {@link Element}s and calls the {@link NodeLinkerLvl1}
	 * in case of an explicit intent definition.
	 */
	public void analyzeExplicitIntents() {
		for (final Collection<IntentInformation> intentInfoCollection : this.ei.getIntents().values()) {
			for (final IntentInformation intentInfo : intentInfoCollection) {
				if (intentInfo.getTypeIntent() == IntentInformation.TYPE_EXPLICIT) {
					this.nodeLinker.link(intentInfo);
				}
			}
		}
	}

	public AnalysisGraph getGraph() {
		return this.resultGraph;
	}
}
