package de.upb.pga3.panda2.extension.lvl1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is used as data structure for the analysis Level 1 result. It
 * simply holds an arbitrary amount of leafs.
 *
 * @author Felix
 *
 */
public class ResultTreeLvl1 {
	private Map<String, ResultLeafLvl1> leafs;

	public ResultTreeLvl1() {
		this.leafs = new HashMap<>();
	}

	public Map<String, ResultLeafLvl1> getLeafs() {
		return this.leafs;
	}

	public List<ResultLeafLvl1> getLeafsAsList() {
		return new ArrayList<>(this.leafs.values());
	}

	public void addLeaf(final ResultLeafLvl1 leaf) {
		this.leafs.put(leaf.getName(), leaf);
	}

	public ResultLeafLvl1 getLeaf(final String key) {
		return this.leafs.get(key);
	}
}