package de.upb.pga3.panda2.extension.lvl1;

import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.core.datastructures.Permission;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

/**
 * This class is used to created leafes for any {@link ResultTreeLvl1}.
 *
 * @author Felix
 *
 */
public class ResultLeafLvl1 {
	// Data stored in a leaf
	private String inName;
	private TIntObjectMap<List<Permission>> inPermissions;

	/**
	 * Constructor creating a new leaf
	 *
	 * @param inName
	 *            the name of the element, which belongs to this leaf.
	 */
	public ResultLeafLvl1(final String inName) {
		this.inName = inName;
		this.inPermissions = new TIntObjectHashMap<>();
		for (int i = 0; i < 5; i++) {
			this.inPermissions.put(i, new ArrayList<Permission>());
		}
	}

	/**
	 * The name of the element referenced by this leaf.
	 *
	 * @return the elements name (E.g. the jimple representation of a class).
	 */
	public String getName() {
		return this.inName;
	}

	/**
	 * Returns all {@link Permission}s assigned to this leaf.
	 *
	 * @param type
	 *            Permission-Group of the returned {@link Permission}s.
	 * @return List of {@link Permission}s
	 */
	public List<Permission> getPermissions(final int type) {
		if (type == ResultTypeLvl1.ALL) {
			final List<Permission> all = new ArrayList<>();
			for (int i = 0; i < 5; i++) {
				all.addAll(getPermissions(i));
			}
			return all;
		} else {
			return this.inPermissions.get(type);
		}
	}

	/**
	 * Adds a {@link Permission} to this leaf
	 *
	 * @param permission
	 *            Permission to be added.
	 * @param type
	 *            Definition of the Permission-Group the permission defined in
	 *            the first parameter belongs to.
	 */
	public void addPermission(final Permission permission, final int type) {
		if (this.inPermissions.get(type).contains(permission)) {
			return;
		}
		this.inPermissions.get(type).add(permission);
	}
}
