package de.upb.pga3.panda2.core.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author RamKumar
 */

public class XMLHandler {

	public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
	protected byte[] xml;
	protected LayoutBinaryParser parser;

	/* Implementation of this class is similar to that in Flowdroid */

	public XMLHandler(final InputStream xmlInput, final LayoutBinaryParser parser) throws IOException {
		if (xmlInput == null) {
			throw new RuntimeException("NULL input stream for AXmlHandler");
		}

		/* Wrapping input stream in a BufferedInputStream */

		final BufferedInputStream buffer = new BufferedInputStream(xmlInput);

		/* read xml one time for writing the output */
		{
			final List<byte[]> chunks = new ArrayList<byte[]>();
			int bytesRead = 0;
			while (xmlInput.available() > 0) {
				final byte[] nextChunk = new byte[xmlInput.available()];
				final int chunkSize = buffer.read(nextChunk);
				if (chunkSize < 0) {
					break;
				}
				chunks.add(nextChunk);
				bytesRead += chunkSize;
			}

			// Create the full array

			this.xml = new byte[bytesRead];
			int bytesCopied = 0;
			for (final byte[] chunk : chunks) {
				final int toCopy = Math.min(chunk.length, bytesRead - bytesCopied);
				System.arraycopy(chunk, 0, this.xml, bytesCopied, toCopy);
				bytesCopied += toCopy;
			}
		}

		parser.parseFile(this.xml);
		this.parser = parser;
	}

	/**
	 * Return the XML document
	 *
	 * @return XMLDocument
	 */
	public XMLDocument getDocument() {
		return this.parser.getDocument();
	}

}
