package de.upb.pga3.panda2.core.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * @author RamKumar
 */

public class XMLDocument {

	private XMLNode rootNode;

	Map<String, XMLNamespace> namespaces = null;

	/**
	 * Get root node in the document
	 *
	 * @return XMLNode root node
	 */
	public XMLNode getRootNode() {
		return this.rootNode;
	}

	/**
	 * Set root node in the document
	 *
	 * @param rootNode
	 *            XMLNode root node
	 */
	public void setRootNode(final XMLNode rootNode) {
		this.rootNode = rootNode;
	}

	/**
	 * Add namespace
	 *
	 * @param ns
	 *            namespace
	 */
	public void addNamespace(final XMLNamespace ns) {

		if (ns.getUri() == null || ns.getUri().isEmpty()) {
			return;
		}

		if (this.namespaces == null) {
			this.namespaces = new HashMap<String, XMLNamespace>();
		}
		this.namespaces.put(ns.getPrefix(), ns);
	}

	/**
	 * Return name spaces in the document
	 *
	 * @return Collection of name spaces
	 */
	public Collection<XMLNamespace> getNamespaces() {
		return this.namespaces.values();
	}

}
