package de.upb.pga3.panda2.core.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import pxb.android.axml.ValueWrapper;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.Tag;

/**
 * @author RamKumar
 *
 *         The implementation is based on the parser implementation from
 *         Flowdroid
 */

public class LayoutBinaryParser {

	private final Map<Integer, String> idToNameMap = new HashMap<Integer, String>();
	protected HashMap<String, ArrayList<XMLNode>> nodesWithTag = new HashMap<String, ArrayList<XMLNode>>();
	protected XMLDocument document = new XMLDocument();

	/* This implementation is similar to that in Flowdroid */

	private class MynodeVisitor extends AxmlVisitor {

		public final XMLNode node;

		public MynodeVisitor() {
			this.node = new XMLNode("dummy", "", null);
		}

		public MynodeVisitor(final XMLNode node) {
			this.node = node;
		}

		@Override
		public void attr(String ns, final String name, final int resourceId, final int type, final Object obj) {
			if (this.node == null) {
				throw new RuntimeException("NULL nodes cannot have attributes");
			}

			String tname = name;

			// If we have no node name, we use the resourceId to look up the
			// attribute in the android.R.attr class.
			if (tname == null || tname.isEmpty()) {
				tname = LayoutBinaryParser.this.idToNameMap.get(resourceId);
				if (tname == null) {
					final SootClass rClass = Scene.v().forceResolve("android.R$attr", SootClass.BODIES);
					outer: for (final SootField sf : rClass.getFields()) {
						for (final Tag t : sf.getTags()) {
							if (t instanceof IntegerConstantValueTag) {
								final IntegerConstantValueTag cvt = (IntegerConstantValueTag) t;
								if (cvt.getIntValue() == resourceId) {
									tname = sf.getName();
									LayoutBinaryParser.this.idToNameMap.put(resourceId, tname);
									// fake the Android namespace
									ns = "http://schemas.android.com/apk/res/android";
									break outer;
								}
								break;
							}
						}
					}
				}
			} else {
				tname = name.trim();
			}

			// Read out the field data
			if (type == AxmlVisitor.TYPE_REFERENCE || type == AxmlVisitor.TYPE_INT_HEX
					|| type == AxmlVisitor.TYPE_FIRST_INT) {
				if (obj instanceof Integer) {
					this.node
							.addAttribute(new XMLAttribute<Integer>(tname, resourceId, type, (Integer) obj, ns, false));
				} else if (obj instanceof ValueWrapper) {
					final ValueWrapper wrapper = (ValueWrapper) obj;
					this.node.addAttribute(new XMLAttribute<String>(tname, resourceId, type, wrapper.raw, ns, false));
				} else {
					throw new RuntimeException("Unsupported value type");
				}
			} else if (type == AxmlVisitor.TYPE_STRING) {
				if (obj instanceof String) {
					this.node.addAttribute(new XMLAttribute<String>(tname, resourceId, type, (String) obj, ns, false));
				} else if (obj instanceof ValueWrapper) {
					final ValueWrapper wrapper = (ValueWrapper) obj;
					this.node.addAttribute(new XMLAttribute<String>(tname, resourceId, type, wrapper.raw, ns, false));
				} else {
					throw new RuntimeException("Unsupported value type");
				}
			} else if (type == AxmlVisitor.TYPE_INT_BOOLEAN) {
				if (obj instanceof Boolean) {
					this.node
							.addAttribute(new XMLAttribute<Boolean>(tname, resourceId, type, (Boolean) obj, ns, false));
				} else if (obj instanceof ValueWrapper) {
					final ValueWrapper wrapper = (ValueWrapper) obj;
					this.node.addAttribute(new XMLAttribute<Boolean>(tname, resourceId, type,
							Boolean.valueOf(wrapper.raw), ns, false));
				} else {
					throw new RuntimeException("Unsupported value type");
				}
			}

			super.attr(ns, name, resourceId, type, obj);
		}

		@Override
		public NodeVisitor child(final String ns, final String name) {
			final XMLNode childNode = new XMLNode(name == null ? null : name.trim(), ns == null ? null : ns.trim(),
					this.node);
			if (name != null) {
				addPointer(name, childNode);
			}
			return new MynodeVisitor(childNode);
		}

		@Override
		public void end() {
			LayoutBinaryParser.this.document.setRootNode(this.node);
		}

		@Override
		public void ns(final String prefix, final String uri, final int line) {
			LayoutBinaryParser.this.document.addNamespace(new XMLNamespace(prefix, uri, line));
		}

	}

	public void parseFile(final byte[] buffer) throws IOException {
		final AxmlReader rdr = new AxmlReader(buffer);
		rdr.accept(new MynodeVisitor());
	}

	public XMLDocument getDocument() {
		return this.document;
	}

	protected void addPointer(final String tag, final XMLNode node) {
		if (!this.nodesWithTag.containsKey(tag)) {
			this.nodesWithTag.put(tag, new ArrayList<XMLNode>());
		}
		this.nodesWithTag.get(tag).add(node);
	}

}
