package de.upb.pga3.panda2.core.services;

import java.util.List;
import java.util.Map;
import java.util.Set;

import de.upb.pga3.panda2.core.datastructures.Permission;

/**
 * @author Felix
 */
public interface DataStorage {
	/**
	 * This method should provide a list of permissions based on the permissions
	 * used by the Android API Call defined by its method name and the
	 * class-name of the class calling it.
	 *
	 * @param pkgClass
	 *            Combination of package-name and class-name
	 * @param method
	 *            method-name including parameters of this method
	 * @return List of involved permissions
	 */
	public List<Permission> mapAPICall(String pkgClass, String method);

	/**
	 * This method should provide a list of permissions based on the permissions
	 * used by the component targeted with this action name.
	 *
	 * @param actionName
	 *            Identifying the targeted component by referring to an Android
	 *            intent filter.
	 * @return List of involved permissions
	 */
	public List<Permission> mapImplicitIntent(String actionName);

	/**
	 * This method should provide a list of permissions based on the permissions
	 * used by the component accessed by an uri.
	 *
	 * @param uri
	 *            URI used to access the content provider of the Android system
	 * @return List of involved permissions
	 */
	public List<Permission> mapContentProviderURI(String uri);

	/**
	 * Provides a list of all permissions belonging to the current API level.
	 *
	 * @return List of involved permissions
	 */
	public Map<String, Permission> getAllPermissions();

	/**
	 * Replies the Android API version which is used by the datastorage.
	 *
	 * @return The current API level supported by this datastorage
	 */
	public int getMaxAPILevel();

	/**
	 * check whether an API is source
	 *
	 * @param inClassName
	 * @param inSignature
	 * @return
	 */
	public boolean isSource(String inClassName, String inSignature);

	/**
	 * check whether an API is sink
	 *
	 * @param inClassName
	 * @param inSignature
	 * @return
	 */
	public boolean isSink(String inClassName, String inSignature);

	/**
	 * Method to parse android call back file
	 *
	 * @return
	 */
	public Set<String> getCallBackClasses();

}
