package de.upb.pga3.panda2.core.services;

/**
 * This class is used for accessing the DataStorage, the StatementAnalyzer and
 * the XMLParser. Because of that only this file has to be edited in order to
 * exchange one of these {@link CoreServices}.
 *
 * @author Felix
 */
public class CoreServices {
	// Instances
	private final static DataStorage DATASTORAGEINSTANCE = A3DataStorage.getInstance();
	private final static StatementAnalyzer STATEMENTANALYZERINSTANCE = A3StatementAnalyzer.getInstance();
	private final static XMLParser XMLPARSERINSTANCE = A3XMLParser.getInstance();

	// Getters
	public static DataStorage getDataStorageInstance() {
		return DATASTORAGEINSTANCE;
	}

	public static StatementAnalyzer getStatementAnalyzerInstance() {
		return STATEMENTANALYZERINSTANCE;
	}

	public static XMLParser getXMLParserInstance() {
		return XMLPARSERINSTANCE;
	}
}
