/**
 * 
 */
package de.upb.pga3.panda2.core.services;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.utilities.Constants;

/**
 * 
 * @author nptsy
 */
public class CertParser extends BinaryParser {

	// logger
	private static final Logger LOGGER = LogManager.getLogger(CertParser.class);

	// finger print in MD5
	private String mMD5Fingerprint;

	// finger print in SHA
	private String mSHA1Fingerprint;

	/**
	 * Constuctor
	 * 
	 * @param inAPKFile
	 */
	public CertParser(final String inAPKFile) {
		super(inAPKFile);
	}

	@Override
	protected boolean parseData(final String inAPKFile) {
		final File f = new File(inAPKFile);
		this.mMD5Fingerprint = getSignaturFromAPL(f, Constants.MD5_MODE);
		this.mSHA1Fingerprint = getSignaturFromAPL(f, Constants.SHA1_MODE);
		return true;
	}

	/**
	 * get fingerprint (MD5)
	 * 
	 * @return a string of fingerprint
	 */
	public String getMd5Fingerprint() {
		return this.mMD5Fingerprint;
	}

	/**
	 * get finger print (SHA1)
	 * 
	 * @return a string of fingerprint
	 */
	public String getSHA1FingerPrint() {
		return this.mSHA1Fingerprint;
	}

	private String getSignaturFromAPL(final File apkFile, final String inMode) {
		final String key = "";

		try {

			final ZipFile file = new ZipFile(apkFile, ZipFile.OPEN_READ);
			final Enumeration<ZipEntry> lstZipEntries = (Enumeration<ZipEntry>) file
					.entries();

			boolean isRSAExisting = false;
			ZipEntry RSAZipEntry = new ZipEntry("");
			while (lstZipEntries.hasMoreElements()) {
				RSAZipEntry = lstZipEntries.nextElement();
				final String RSAFileName = RSAZipEntry.getName();
				if (RSAFileName.endsWith(Constants.RSA_EXTENSION)) {
					isRSAExisting = true;
					break;
				}
			}

			if (isRSAExisting) {
				final InputStream tream = file.getInputStream(RSAZipEntry);

				final DataInputStream dis = new DataInputStream(tream);

				final byte[] keyBytes = new byte[(int) RSAZipEntry.getSize()];
				dis.readFully(keyBytes);
				dis.close();

				// **********************************************************
				// THIS SOUCE CODE BELONGS TO FELIX <= processing for getting
				// MD5 hashed code in file CERT.RSA
				// **********************************************************
				MessageDigest digest;
				try {
					digest = MessageDigest.getInstance(inMode);
				} catch (final NoSuchAlgorithmException e) {
					return null;
				}

				final byte[] buffer = new byte[8192];
				final int read;
				digest.update(keyBytes);
				final byte[] md5sum = digest.digest();
				final BigInteger bigInt = new BigInteger(1, md5sum);
				String output = bigInt.toString(16);
				// Fill to 32 chars
				output = String.format("%32s", output).replace(' ', '0');
				return output;
				// **********************************************************
				// [End]
				// **********************************************************
			}

		} catch (final Exception ex) {
			LOGGER.info("Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

		return key;
	}
}
