package de.upb.pga3.panda2.core.datastructures;

/**
 * Transition class handles the connection between elements.
 *
 * @author nptsy
 * @author Fabian
 */
public class Transition {

	// source element
	protected Object mEleFrom;
	// target or destination element
	protected Object mEleTo;

	/**
	 * Constructor
	 *
	 * @param inEleFrom
	 *            source element
	 * @param inEleTo
	 *            target or destination element
	 */
	public Transition(final Object inEleFrom, final Object inEleTo) {

		if (inEleFrom == null || inEleTo == null) {
			throw new IllegalArgumentException("Source and target of a transition must not be null!");
		}
		this.mEleFrom = inEleFrom;
		this.mEleTo = inEleTo;
	}

	/**
	 * get target element
	 *
	 * @return target element
	 */
	public Object getTarget() {
		return this.mEleTo;
	}

	/**
	 * get source element
	 *
	 * @return source element
	 */
	public Object getSource() {
		return this.mEleFrom;
	}
}
