package de.upb.pga3.panda2.core.datastructures;


/**
 * Message class handles message information for each case of analysis result
 *
 * @author nptsy
 */
public class Message {
	// type of message => set enum MessageType for more detail
	private MessageType mMsgType;
	// message title
	private String mStrTitle;
	// message body
	private String mStrBody;

	/**
	 * Constructor
	 *
	 * @param inMsgType
	 *            message type
	 * @param inTitle
	 *            title of message
	 * @param inBody
	 *            body content of message
	 */
	public Message(final MessageType inMsgType, final String inTitle, final String inBody) {
		this.mMsgType = inMsgType;
		this.mStrTitle = inTitle;
		this.mStrBody = inBody;
	}

	/**
	 * get body content of massage
	 *
	 * @return string body content of message
	 */
	public String getBody() {
		return this.mStrBody;
	}

	/**
	 * get title of message
	 *
	 * @return
	 */
	public String getTitle() {
		return this.mStrTitle;
	}

	/**
	 * get type of message
	 *
	 * @see MessageType
	 * @return
	 */
	public MessageType getType() {
		return this.mMsgType;
	}
}
